/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java;

import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.java.JavaNullabilityAnnotationsStatus;
import org.jetbrains.kotlin.load.java.Jsr305Settings;
import org.jetbrains.kotlin.load.java.NullabilityAnnotationStates;
import org.jetbrains.kotlin.load.java.NullabilityAnnotationStatesImpl;
import org.jetbrains.kotlin.load.java.ReportLevel;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u0010\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u001a\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0011\u001a\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0001\u001a&\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00012\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00110\t2\b\b\u0002\u0010\u000e\u001a\u00020\u000f\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"CHECKER_FRAMEWORK_COMPATQUAL_ANNOTATIONS_PACKAGE", "Lorg/jetbrains/kotlin/name/FqName;", "getCHECKER_FRAMEWORK_COMPATQUAL_ANNOTATIONS_PACKAGE", "()Lorg/jetbrains/kotlin/name/FqName;", "JSPECIFY_ANNOTATIONS_PACKAGE", "getJSPECIFY_ANNOTATIONS_PACKAGE", "JSR_305_DEFAULT_SETTINGS", "Lorg/jetbrains/kotlin/load/java/JavaNullabilityAnnotationsStatus;", "NULLABILITY_ANNOTATION_SETTINGS", "Lorg/jetbrains/kotlin/load/java/NullabilityAnnotationStates;", "getNULLABILITY_ANNOTATION_SETTINGS", "()Lorg/jetbrains/kotlin/load/java/NullabilityAnnotationStates;", "getDefaultJsr305Settings", "Lorg/jetbrains/kotlin/load/java/Jsr305Settings;", "configuredKotlinVersion", "Lkotlin/KotlinVersion;", "getDefaultMigrationJsr305ReportLevelForGivenGlobal", "Lorg/jetbrains/kotlin/load/java/ReportLevel;", "globalReportLevel", "getDefaultReportLevelForAnnotation", "annotationFqName", "getReportLevelForAnnotation", "annotation", "configuredReportLevels", "compiler.common.jvm"})
public final class JavaNullabilityAnnotationSettingsKt {
    @NotNull
    private static final FqName JSPECIFY_ANNOTATIONS_PACKAGE = new FqName("org.jspecify.nullness");
    @NotNull
    private static final FqName CHECKER_FRAMEWORK_COMPATQUAL_ANNOTATIONS_PACKAGE = new FqName("org.checkerframework.checker.nullness.compatqual");
    @NotNull
    private static final NullabilityAnnotationStates<JavaNullabilityAnnotationsStatus> NULLABILITY_ANNOTATION_SETTINGS;
    @NotNull
    private static final JavaNullabilityAnnotationsStatus JSR_305_DEFAULT_SETTINGS;

    @NotNull
    public static final FqName getJSPECIFY_ANNOTATIONS_PACKAGE() {
        return JSPECIFY_ANNOTATIONS_PACKAGE;
    }

    @NotNull
    public static final FqName getCHECKER_FRAMEWORK_COMPATQUAL_ANNOTATIONS_PACKAGE() {
        return CHECKER_FRAMEWORK_COMPATQUAL_ANNOTATIONS_PACKAGE;
    }

    @NotNull
    public static final NullabilityAnnotationStates<JavaNullabilityAnnotationsStatus> getNULLABILITY_ANNOTATION_SETTINGS() {
        return NULLABILITY_ANNOTATION_SETTINGS;
    }

    @NotNull
    public static final Jsr305Settings getDefaultJsr305Settings(@NotNull KotlinVersion configuredKotlinVersion) {
        Intrinsics.checkNotNullParameter((Object)configuredKotlinVersion, (String)"configuredKotlinVersion");
        ReportLevel globalReportLevel = JSR_305_DEFAULT_SETTINGS.getSinceVersion() != null && JSR_305_DEFAULT_SETTINGS.getSinceVersion().compareTo(configuredKotlinVersion) <= 0 ? JSR_305_DEFAULT_SETTINGS.getReportLevelAfter() : JSR_305_DEFAULT_SETTINGS.getReportLevelBefore();
        ReportLevel migrationLevel = JavaNullabilityAnnotationSettingsKt.getDefaultMigrationJsr305ReportLevelForGivenGlobal(globalReportLevel);
        return new Jsr305Settings(globalReportLevel, migrationLevel, null, 4, null);
    }

    public static /* synthetic */ Jsr305Settings getDefaultJsr305Settings$default(KotlinVersion kotlinVersion, int n, Object object) {
        if ((n & 1) != 0) {
            kotlinVersion = KotlinVersion.CURRENT;
        }
        return JavaNullabilityAnnotationSettingsKt.getDefaultJsr305Settings(kotlinVersion);
    }

    @Nullable
    public static final ReportLevel getDefaultMigrationJsr305ReportLevelForGivenGlobal(@NotNull ReportLevel globalReportLevel) {
        Intrinsics.checkNotNullParameter((Object)((Object)globalReportLevel), (String)"globalReportLevel");
        return globalReportLevel == ReportLevel.WARN ? null : globalReportLevel;
    }

    @NotNull
    public static final ReportLevel getDefaultReportLevelForAnnotation(@NotNull FqName annotationFqName) {
        Intrinsics.checkNotNullParameter((Object)annotationFqName, (String)"annotationFqName");
        return JavaNullabilityAnnotationSettingsKt.getReportLevelForAnnotation$default(annotationFqName, NullabilityAnnotationStates.Companion.getEMPTY(), null, 4, null);
    }

    @NotNull
    public static final ReportLevel getReportLevelForAnnotation(@NotNull FqName annotation2, @NotNull NullabilityAnnotationStates<? extends ReportLevel> configuredReportLevels, @NotNull KotlinVersion configuredKotlinVersion) {
        Intrinsics.checkNotNullParameter((Object)annotation2, (String)"annotation");
        Intrinsics.checkNotNullParameter(configuredReportLevels, (String)"configuredReportLevels");
        Intrinsics.checkNotNullParameter((Object)configuredKotlinVersion, (String)"configuredKotlinVersion");
        ReportLevel reportLevel = configuredReportLevels.get(annotation2);
        if (reportLevel != null) {
            ReportLevel it = reportLevel;
            boolean bl = false;
            return it;
        }
        JavaNullabilityAnnotationsStatus javaNullabilityAnnotationsStatus = NULLABILITY_ANNOTATION_SETTINGS.get(annotation2);
        if (javaNullabilityAnnotationsStatus == null) {
            return ReportLevel.IGNORE;
        }
        JavaNullabilityAnnotationsStatus defaultStatus = javaNullabilityAnnotationsStatus;
        return defaultStatus.getSinceVersion() != null && defaultStatus.getSinceVersion().compareTo(configuredKotlinVersion) <= 0 ? defaultStatus.getReportLevelAfter() : defaultStatus.getReportLevelBefore();
    }

    public static /* synthetic */ ReportLevel getReportLevelForAnnotation$default(FqName fqName2, NullabilityAnnotationStates nullabilityAnnotationStates, KotlinVersion kotlinVersion, int n, Object object) {
        if ((n & 4) != 0) {
            kotlinVersion = KotlinVersion.CURRENT;
        }
        return JavaNullabilityAnnotationSettingsKt.getReportLevelForAnnotation(fqName2, nullabilityAnnotationStates, kotlinVersion);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)new FqName("org.jetbrains.annotations"), (Object)JavaNullabilityAnnotationsStatus.Companion.getDEFAULT()), TuplesKt.to((Object)new FqName("androidx.annotation"), (Object)JavaNullabilityAnnotationsStatus.Companion.getDEFAULT()), TuplesKt.to((Object)new FqName("android.support.annotation"), (Object)JavaNullabilityAnnotationsStatus.Companion.getDEFAULT()), TuplesKt.to((Object)new FqName("android.annotation"), (Object)JavaNullabilityAnnotationsStatus.Companion.getDEFAULT()), TuplesKt.to((Object)new FqName("com.android.annotations"), (Object)JavaNullabilityAnnotationsStatus.Companion.getDEFAULT()), TuplesKt.to((Object)new FqName("org.eclipse.jdt.annotation"), (Object)JavaNullabilityAnnotationsStatus.Companion.getDEFAULT()), TuplesKt.to((Object)new FqName("org.checkerframework.checker.nullness.qual"), (Object)JavaNullabilityAnnotationsStatus.Companion.getDEFAULT()), TuplesKt.to((Object)CHECKER_FRAMEWORK_COMPATQUAL_ANNOTATIONS_PACKAGE, (Object)JavaNullabilityAnnotationsStatus.Companion.getDEFAULT()), TuplesKt.to((Object)new FqName("javax.annotation"), (Object)JavaNullabilityAnnotationsStatus.Companion.getDEFAULT()), TuplesKt.to((Object)new FqName("edu.umd.cs.findbugs.annotations"), (Object)JavaNullabilityAnnotationsStatus.Companion.getDEFAULT()), TuplesKt.to((Object)new FqName("io.reactivex.annotations"), (Object)JavaNullabilityAnnotationsStatus.Companion.getDEFAULT()), TuplesKt.to((Object)new FqName("androidx.annotation.RecentlyNullable"), (Object)new JavaNullabilityAnnotationsStatus(ReportLevel.WARN, null, null, 4, null)), TuplesKt.to((Object)new FqName("androidx.annotation.RecentlyNonNull"), (Object)new JavaNullabilityAnnotationsStatus(ReportLevel.WARN, null, null, 4, null)), TuplesKt.to((Object)new FqName("lombok"), (Object)JavaNullabilityAnnotationsStatus.Companion.getDEFAULT()), TuplesKt.to((Object)JSPECIFY_ANNOTATIONS_PACKAGE, (Object)new JavaNullabilityAnnotationsStatus(ReportLevel.WARN, new KotlinVersion(1, 7), ReportLevel.STRICT)), TuplesKt.to((Object)new FqName("io.reactivex.rxjava3.annotations"), (Object)new JavaNullabilityAnnotationsStatus(ReportLevel.WARN, new KotlinVersion(1, 7), ReportLevel.STRICT))};
        NULLABILITY_ANNOTATION_SETTINGS = new NullabilityAnnotationStatesImpl(MapsKt.mapOf((Pair[])pairArray));
        JSR_305_DEFAULT_SETTINGS = new JavaNullabilityAnnotationsStatus(ReportLevel.WARN, null, null, 4, null);
    }
}

