/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.IOException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.Pipe;
import java.util.concurrent.atomic.AtomicBoolean;
import org.xnio.Option;
import org.xnio.nio.AbstractNioStreamSinkChannel;
import org.xnio.nio.NioXnio;

final class NioPipeSinkChannel
extends AbstractNioStreamSinkChannel<NioPipeSinkChannel> {
    private final Pipe.SinkChannel channel;
    private final AtomicBoolean callFlag = new AtomicBoolean(false);

    NioPipeSinkChannel(NioXnio xnio, Pipe.SinkChannel channel) {
        super(xnio);
        this.channel = channel;
    }

    @Override
    protected GatheringByteChannel getWriteChannel() {
        return this.channel;
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public void close() throws IOException {
        if (!this.callFlag.getAndSet(true)) {
            this.invokeCloseHandler();
            this.channel.close();
        }
    }

    public boolean shutdownWrites() throws IOException {
        this.close();
        return true;
    }

    public boolean supportsOption(Option<?> option) {
        return false;
    }

    public <T> T getOption(Option<T> option) throws IOException {
        return null;
    }

    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return null;
    }

    public String toString() {
        return String.format("pipe sink channel (NIO) <%s>", Integer.toString(this.hashCode(), 16));
    }
}

