/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.se;

import java.lang.annotation.Annotation;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.api.Environments;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.context.api.BeanStore;
import org.jboss.weld.context.api.helpers.ConcurrentHashMapBeanStore;
import org.jboss.weld.environment.se.ShutdownManager;
import org.jboss.weld.environment.se.WeldContainer;
import org.jboss.weld.environment.se.beans.InstanceManager;
import org.jboss.weld.environment.se.discovery.SEWeldDeployment;
import org.jboss.weld.environment.se.util.Reflections;
import org.jboss.weld.environment.se.util.WeldManagerUtils;
import org.jboss.weld.manager.api.WeldManager;

public class Weld {
    private static final String BOOTSTRAP_IMPL_CLASS_NAME = "org.jboss.weld.bootstrap.WeldBootstrap";
    private final Bootstrap bootstrap;
    private final BeanStore applicationBeanStore;
    private WeldManager manager;

    public Weld() {
        try {
            this.bootstrap = Reflections.newInstance(BOOTSTRAP_IMPL_CLASS_NAME, Bootstrap.class);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error loading Weld bootstrap, check that Weld is on the classpath", e);
        }
        this.applicationBeanStore = new ConcurrentHashMapBeanStore();
    }

    @PostConstruct
    public WeldContainer initialize() {
        SEWeldDeployment deployment = new SEWeldDeployment(){};
        this.bootstrap.startContainer(Environments.SE, deployment, this.applicationBeanStore);
        BeanDeploymentArchive mainBeanDepArch = (BeanDeploymentArchive)deployment.getBeanDeploymentArchives().get(0);
        this.manager = this.bootstrap.getManager(mainBeanDepArch);
        this.bootstrap.startInitialization();
        this.bootstrap.deployBeans();
        WeldManagerUtils.getInstanceByType((BeanManager)this.manager, ShutdownManager.class, new Annotation[0]).setBootstrap(this.bootstrap);
        this.bootstrap.validateBeans();
        this.bootstrap.endInitialization();
        InstanceManager instanceManager = WeldManagerUtils.getInstanceByType((BeanManager)this.manager, InstanceManager.class, new Annotation[0]);
        return new WeldContainer(instanceManager, this.manager);
    }

    public void shutdown() {
        WeldManagerUtils.getInstanceByType((BeanManager)this.manager, ShutdownManager.class, new Annotation[0]).shutdown();
    }
}

