/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.lite.extension.translator;

import jakarta.enterprise.event.Observes;
import jakarta.enterprise.event.Reception;
import jakarta.enterprise.event.TransactionPhase;
import jakarta.enterprise.inject.build.compatible.spi.BeanInfo;
import jakarta.enterprise.inject.build.compatible.spi.ObserverInfo;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.AnnotatedCallable;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.ObserverMethod;
import jakarta.enterprise.lang.model.AnnotationInfo;
import jakarta.enterprise.lang.model.declarations.ClassInfo;
import jakarta.enterprise.lang.model.declarations.MethodInfo;
import jakarta.enterprise.lang.model.declarations.ParameterInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.stream.Collectors;
import org.jboss.weld.lite.extension.translator.AnnotationInfoImpl;
import org.jboss.weld.lite.extension.translator.BeanInfoImpl;
import org.jboss.weld.lite.extension.translator.ClassInfoImpl;
import org.jboss.weld.lite.extension.translator.MethodInfoImpl;
import org.jboss.weld.lite.extension.translator.ParameterInfoImpl;
import org.jboss.weld.lite.extension.translator.TypeImpl;
import org.jboss.weld.lite.extension.translator.logging.LiteExtensionTranslatorLogger;
import org.jboss.weld.lite.extension.translator.util.reflection.AnnotatedTypes;

class ObserverInfoImpl
implements ObserverInfo {
    final ObserverMethod<?> cdiObserver;
    final AnnotatedMethod<?> cdiDeclaration;
    final BeanManager bm;

    ObserverInfoImpl(ObserverMethod<?> cdiObserver, AnnotatedMethod<?> cdiDeclaration, BeanManager bm) {
        this.cdiObserver = cdiObserver;
        this.cdiDeclaration = cdiDeclaration;
        this.bm = bm;
    }

    public jakarta.enterprise.lang.model.types.Type eventType() {
        Type observedType = this.cdiObserver.getObservedType();
        return TypeImpl.fromReflectionType(AnnotatedTypes.from(observedType), this.bm);
    }

    public Collection<AnnotationInfo> qualifiers() {
        return this.cdiObserver.getObservedQualifiers().stream().map(annotation -> new AnnotationInfoImpl((Annotation)annotation, this.bm)).collect(Collectors.toList());
    }

    public ClassInfo declaringClass() {
        AnnotatedType beanClass = this.bm.createAnnotatedType(this.cdiObserver.getBeanClass());
        return new ClassInfoImpl(beanClass, this.bm);
    }

    public MethodInfo observerMethod() {
        if (this.cdiDeclaration == null) {
            return null;
        }
        return new MethodInfoImpl((AnnotatedCallable<?>)this.cdiDeclaration, this.bm);
    }

    public ParameterInfo eventParameter() {
        if (this.cdiDeclaration == null) {
            return null;
        }
        for (AnnotatedParameter parameter : this.cdiDeclaration.getParameters()) {
            if (!parameter.isAnnotationPresent(Observes.class)) continue;
            return new ParameterInfoImpl(parameter, this.bm);
        }
        throw LiteExtensionTranslatorLogger.LOG.missingObservesAnnotation(this.cdiDeclaration);
    }

    public BeanInfo bean() {
        if (this.cdiDeclaration == null) {
            return null;
        }
        return new BeanInfoImpl((Bean<?>)this.cdiObserver.getDeclaringBean(), (Annotated)this.cdiDeclaration, null, this.bm);
    }

    public boolean isSynthetic() {
        return this.cdiDeclaration == null;
    }

    public int priority() {
        return this.cdiObserver.getPriority();
    }

    public boolean isAsync() {
        return this.cdiObserver.isAsync();
    }

    public Reception reception() {
        return this.cdiObserver.getReception();
    }

    public TransactionPhase transactionPhase() {
        return this.cdiObserver.getTransactionPhase();
    }

    public String toString() {
        return "observer [type=" + this.cdiObserver.getObservedType() + ", qualifiers=" + this.cdiObserver.getObservedQualifiers() + "]" + (String)(this.cdiDeclaration != null ? " declared at " + this.cdiDeclaration : "");
    }
}

