/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven;

import org.apache.maven.model.Dependency;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.util.artifact.DefaultArtifact;

class ArtifactAsKey {
    private final String groupId;
    private final String artifactId;
    private final String type;
    private final String classifier;

    public ArtifactAsKey(String groupId, String artifactId, String type, String classifier) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.type = type == null || type.length() == 0 ? "jar" : type;
        this.classifier = classifier == null || classifier.length() == 0 ? "" : classifier;
    }

    public ArtifactAsKey(String coordinates) {
        this((Artifact)new DefaultArtifact(coordinates));
    }

    public ArtifactAsKey(Dependency d) {
        this(d.getGroupId(), d.getArtifactId(), d.getType(), d.getClassifier());
    }

    public ArtifactAsKey(Artifact a) {
        this(a.getGroupId(), a.getArtifactId(), a.getExtension(), a.getClassifier());
    }

    public String toString() {
        return "ArtifactAsKey [artifactId=" + this.artifactId + ", classifier=" + this.classifier + ", groupId=" + this.groupId + ", type=" + this.type + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
        result = 31 * result + (this.classifier == null ? 0 : this.classifier.hashCode());
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArtifactAsKey other = (ArtifactAsKey)obj;
        if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
            return false;
        }
        if (this.classifier == null ? other.classifier != null : !this.classifier.equals(other.classifier)) {
            return false;
        }
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

