/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.api.maven.coordinate;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.shrinkwrap.resolver.api.maven.PackagingType;
import org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependency;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencyExclusion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MavenDependencyImpl
implements MavenDependency {
    private final MavenCoordinate delegate;
    private final Set<MavenDependencyExclusion> exclusions;
    private final ScopeType scope;
    private final boolean optional;

    MavenDependencyImpl(MavenCoordinate coordinate, ScopeType scope, boolean optional, MavenDependencyExclusion ... exclusions) {
        assert (coordinate != null) : "coodinate is required";
        this.delegate = coordinate;
        this.scope = scope == null ? ScopeType.COMPILE : scope;
        this.optional = optional;
        HashSet<MavenDependencyExclusion> exclusionsToSet = new HashSet<MavenDependencyExclusion>(exclusions == null ? 0 : exclusions.length);
        if (exclusions != null) {
            for (MavenDependencyExclusion exclusion : exclusions) {
                if (exclusion == null) continue;
                exclusionsToSet.add(exclusion);
            }
        }
        this.exclusions = Collections.unmodifiableSet(exclusionsToSet);
    }

    @Override
    public String getGroupId() {
        return this.delegate.getGroupId();
    }

    public String toCanonicalForm() {
        return this.delegate.toCanonicalForm();
    }

    @Override
    public String getArtifactId() {
        return this.delegate.getArtifactId();
    }

    @Override
    public PackagingType getPackaging() {
        return this.delegate.getPackaging();
    }

    @Override
    public PackagingType getType() {
        return this.delegate.getType();
    }

    @Override
    public String getClassifier() {
        return this.delegate.getClassifier();
    }

    @Override
    public String getVersion() {
        return this.delegate.getVersion();
    }

    @Override
    public Set<MavenDependencyExclusion> getExclusions() {
        return this.exclusions;
    }

    @Override
    public ScopeType getScope() {
        return this.scope;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.delegate == null ? 0 : this.delegate.hashCode());
        result = 31 * result + (this.exclusions == null ? 0 : this.exclusions.hashCode());
        result = 31 * result + (this.optional ? 1231 : 1237);
        result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MavenDependencyImpl other = (MavenDependencyImpl)obj;
        return !(this.delegate == null ? other.delegate != null : !this.delegate.equals(other.delegate));
    }

    public String toString() {
        return MavenDependency.class.getSimpleName() + " [" + this.toCanonicalForm() + "]";
    }
}

