/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jackson;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import com.github.fge.jsonpatch.mergepatch.JsonMergePatch;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.annotation.Priority;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.plugins.providers.jackson.WhiteListPolymorphicTypeValidatorBuilder;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.specimpl.MultivaluedTreeMap;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResourceInvoker;
import org.jboss.resteasy.spi.ResteasyConfiguration;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

@Provider
@Priority(value=0x7FFFFFFF)
public class PatchMethodFilter
implements ContainerRequestFilter {
    public static final String APPLICATION_JSON_MERGE_PATCH_JSON = "application/merge-patch+json";
    public static final MediaType APPLICATION_JSON_MERGE_PATCH_JSON_TYPE = new MediaType("application", "merge-patch+json");
    private volatile ObjectMapper objectMapper;
    @Context
    protected Providers providers;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (requestContext.getMethod().equals("PATCH") && (MediaType.APPLICATION_JSON_PATCH_JSON_TYPE.isCompatible(requestContext.getMediaType()) || APPLICATION_JSON_MERGE_PATCH_JSON_TYPE.isCompatible(requestContext.getMediaType()))) {
            ResteasyConfiguration context = (ResteasyConfiguration)ResteasyContext.getContextData(ResteasyConfiguration.class);
            boolean disabled = false;
            disabled = context == null ? Boolean.getBoolean("resteasy.patchfilter.disabled") : Boolean.parseBoolean(context.getParameter("resteasy.patchfilter.disabled"));
            if (disabled) {
                return;
            }
            HttpRequest request = (HttpRequest)ResteasyContext.getContextData(HttpRequest.class);
            request.setHttpMethod("GET");
            ArrayList<String> patchContentTypeList = new ArrayList<String>();
            for (Object header : request.getHttpHeaders().getRequestHeader("Content-Type")) {
                patchContentTypeList.add((String)header);
            }
            ArrayList<String> acceptHeaders = new ArrayList<String>();
            for (String header : request.getHttpHeaders().getRequestHeader("Accept")) {
                acceptHeaders.add(header);
            }
            requestContext.getHeaders().putSingle((Object)"Content-Type", (Object)"*/*");
            requestContext.getHeaders().putSingle((Object)"Accept", (Object)"application/json");
            HttpResponse response = (HttpResponse)ResteasyContext.getContextData(HttpResponse.class);
            Registry methodRegistry = (Registry)ResteasyContext.getContextData(Registry.class);
            ResourceInvoker resourceInovker = null;
            try {
                resourceInovker = methodRegistry.getResourceInvoker(request);
            }
            catch (Exception e) {
                LogMessages.LOGGER.patchTargetMethodNotFound(requestContext.getUriInfo().getRequestUri().toString());
                throw new ProcessingException("GET method returns the patch/merge json object target not found");
            }
            ResourceMethodInvoker methodInvoker = (ResourceMethodInvoker)resourceInovker;
            Object targetObject = null;
            try {
                targetObject = methodInvoker.invokeDryRun(request, response).toCompletableFuture().getNow(null);
            }
            catch (Exception e) {
                if (e.getCause() instanceof WebApplicationException) {
                    throw e;
                }
                LogMessages.LOGGER.errorPatchTarget(requestContext.getUriInfo().getRequestUri().toString());
                throw new ProcessingException("Unexpected error to get the json patch/merge target", (Throwable)e);
            }
            try {
                ByteArrayOutputStream tmpOutputStream = new ByteArrayOutputStream();
                MessageBodyWriter msgBodyWriter = ResteasyProviderFactory.getInstance().getMessageBodyWriter(targetObject.getClass(), targetObject.getClass(), methodInvoker.getMethodAnnotations(), MediaType.APPLICATION_JSON_TYPE);
                if (msgBodyWriter == null) {
                    throw new ProcessingException(Messages.MESSAGES.couldNotFindWriterForContentType(MediaType.APPLICATION_JSON_TYPE, targetObject.getClass().getName()));
                }
                msgBodyWriter.writeTo(targetObject, targetObject.getClass(), targetObject.getClass(), methodInvoker.getMethodAnnotations(), MediaType.APPLICATION_JSON_TYPE, (MultivaluedMap)new MultivaluedTreeMap(), (OutputStream)tmpOutputStream);
                ObjectMapper mapper = this.getObjectMapper();
                PolymorphicTypeValidator ptv = mapper.getPolymorphicTypeValidator();
                if (ptv == null || ptv instanceof LaissezFaireSubTypeValidator) {
                    mapper.setPolymorphicTypeValidator((PolymorphicTypeValidator)new WhiteListPolymorphicTypeValidatorBuilder().build());
                }
                JsonNode targetJson = (JsonNode)mapper.readValue(tmpOutputStream.toByteArray(), JsonNode.class);
                requestContext.getHeaders().put((Object)"Content-Type", patchContentTypeList);
                requestContext.getHeaders().put((Object)"Accept", acceptHeaders);
                JsonNode result = null;
                if (MediaType.APPLICATION_JSON_PATCH_JSON_TYPE.isCompatible(requestContext.getMediaType())) {
                    JsonPatch patch = JsonPatch.fromJson((JsonNode)((JsonNode)mapper.readValue(request.getInputStream(), JsonNode.class)));
                    result = patch.apply(targetJson);
                } else {
                    JsonMergePatch mergePatch = JsonMergePatch.fromJson((JsonNode)((JsonNode)mapper.readValue(request.getInputStream(), JsonNode.class)));
                    result = mergePatch.apply(targetJson);
                }
                ByteArrayOutputStream targetOutputStream = new ByteArrayOutputStream();
                mapper.writeValue((OutputStream)targetOutputStream, (Object)result);
                request.setInputStream((InputStream)new ByteArrayInputStream(targetOutputStream.toByteArray()));
                request.setHttpMethod("PATCH");
            }
            catch (ProcessingException pe) {
                Throwable c = pe.getCause();
                if (c != null && c instanceof ApplicationException && (c = c.getCause()) != null && c instanceof NotFoundException) {
                    throw (NotFoundException)c;
                }
                throw pe;
            }
            catch (JsonParseException | JsonMappingException e) {
                throw new BadRequestException(e);
            }
            catch (JsonPatchException e) {
                throw new Failure((Throwable)e, 409);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectMapper getObjectMapper() {
        if (this.objectMapper == null) {
            PatchMethodFilter patchMethodFilter = this;
            synchronized (patchMethodFilter) {
                if (this.objectMapper == null) {
                    ObjectMapper contextMapper = this.getContextObjectMapper();
                    this.objectMapper = contextMapper == null ? new ObjectMapper() : contextMapper;
                }
            }
        }
        return this.objectMapper;
    }

    private ObjectMapper getContextObjectMapper() {
        ContextResolver resolver = this.providers.getContextResolver(ObjectMapper.class, MediaType.APPLICATION_JSON_TYPE);
        if (resolver == null) {
            return null;
        }
        return (ObjectMapper)resolver.getContext(ObjectMapper.class);
    }
}

