/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.listener;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.config.ConfigManager;
import com.sun.faces.mgbean.BeanManager;
import com.sun.faces.spi.InjectionProvider;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Enumeration;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.jboss.portletbridge.bridge.context.BridgeContext;

public class PortletBridgeListener
implements ServletContextListener,
HttpSessionListener {
    private static final String MOJARRA_VIEW_SCOPE_MANAGER = "com.sun.faces.application.view.viewScopeManager";
    private static final String MOJARRA_ACTIVE_VIEW_MAPS = "com.sun.faces.application.view.activeViewMaps";
    private static PortletBridgeListener INSTANCE;
    private ServletContext servletContext;
    private ApplicationAssociate applicationAssociate;
    private InjectionProvider injectionProvider;

    public PortletBridgeListener() {
        INSTANCE = this;
    }

    public void contextInitialized(ServletContextEvent sce) {
        if (null == this.servletContext) {
            this.servletContext = sce.getServletContext();
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        Enumeration e = this.servletContext.getAttributeNames();
        while (e.hasMoreElements()) {
            String beanName = (String)e.nextElement();
            this.handleAttributeEvent(beanName, this.servletContext.getAttribute(beanName));
        }
        this.servletContext = null;
        this.applicationAssociate = null;
        INSTANCE = null;
    }

    public void sessionCreated(HttpSessionEvent se) {
        if (null == this.injectionProvider) {
            this.getInjectionProvider();
        }
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        HttpSession session = se.getSession();
        Enumeration attrs = session.getAttributeNames();
        while (attrs.hasMoreElements()) {
            HttpSessionListener viewScopeManager;
            String valueClass;
            boolean destroyCalled;
            int pos;
            String attribute = (String)attrs.nextElement();
            if (null == attribute || !attribute.startsWith("javax.portlet.p.") || (pos = attribute.indexOf(63)) <= 0) continue;
            String jsfAttribute = attribute.substring(pos + 1);
            Object value = session.getAttribute(attribute);
            session.removeAttribute(attribute);
            if (null == value || (destroyCalled = this.handleAttributeEvent(jsfAttribute, value)) || null == (valueClass = value.getClass().getName()) || !valueClass.contains("com.sun.faces")) continue;
            session.setAttribute(jsfAttribute, value);
            if (!MOJARRA_ACTIVE_VIEW_MAPS.equals(jsfAttribute) || null == (viewScopeManager = (HttpSessionListener)this.servletContext.getAttribute(MOJARRA_VIEW_SCOPE_MANAGER))) continue;
            viewScopeManager.sessionDestroyed(se);
        }
    }

    public boolean handleAttributeEvent(String beanName, Object bean) {
        boolean destroyCalled = false;
        ApplicationAssociate associate = this.getAssociate();
        try {
            BeanManager beanManager;
            if (null != associate && null != (beanManager = associate.getBeanManager()) && beanManager.isManaged(beanName)) {
                if (this.scanForAnnotations(bean.getClass())) {
                    beanManager.destroy(beanName, bean);
                } else {
                    this.getInjectionProvider().invokePreDestroy(bean);
                }
                destroyCalled = true;
            }
        }
        catch (Exception e) {
            String className = e.getClass().getName();
            BridgeContext.log((String)("Error calling predestroy on instance of: " + className), (Throwable)e);
        }
        return destroyCalled;
    }

    private ApplicationAssociate getAssociate() {
        if (null == this.applicationAssociate) {
            this.applicationAssociate = ApplicationAssociate.getInstance((ServletContext)this.servletContext);
        }
        return this.applicationAssociate;
    }

    private InjectionProvider getInjectionProvider() {
        FacesContext context;
        if (null == this.injectionProvider && null != (context = FacesContext.getCurrentInstance())) {
            this.injectionProvider = (InjectionProvider)context.getAttributes().get(ConfigManager.INJECTION_PROVIDER_KEY);
        }
        return this.injectionProvider;
    }

    private boolean scanForAnnotations(Class<?> clazz) {
        if (clazz != null) {
            while (clazz != Object.class) {
                Method[] methods;
                Field[] fields = clazz.getDeclaredFields();
                if (fields != null) {
                    for (Field field : fields) {
                        if (field.getAnnotations().length <= 0) continue;
                        return true;
                    }
                }
                if ((methods = clazz.getDeclaredMethods()) != null) {
                    for (Method method : methods) {
                        if (method.getDeclaredAnnotations().length <= 0) continue;
                        return true;
                    }
                }
                clazz = clazz.getSuperclass();
            }
        }
        return false;
    }

    public static PortletBridgeListener getCurrentInstance() {
        return INSTANCE;
    }
}

