/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.context.exception;

import java.util.Iterator;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.NavigationHandler;
import javax.faces.context.ExceptionHandler;
import javax.faces.context.ExceptionHandlerWrapper;
import javax.faces.context.FacesContext;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.ExceptionQueuedEventContext;
import javax.servlet.ServletException;
import org.jboss.portletbridge.bridge.context.BridgeContext;
import org.jboss.portletbridge.bridge.factory.BridgeLoggerFactoryImpl;
import org.jboss.portletbridge.bridge.logger.BridgeLogger;

public class PortletExceptionHandler
extends ExceptionHandlerWrapper {
    private static final BridgeLogger logger = BridgeLoggerFactoryImpl.getLogger(PortletExceptionHandler.class.getName());
    private ExceptionHandler wrapped;

    public PortletExceptionHandler(ExceptionHandler exceptionHandler) {
        this.wrapped = exceptionHandler;
    }

    public ExceptionHandler getWrapped() {
        return this.wrapped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle() throws FacesException {
        BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
        Map errorViews = bridgeContext.getBridgeConfig().getFacesErrorViewMappings();
        Iterator i = this.getUnhandledExceptionQueuedEvents().iterator();
        while (i.hasNext()) {
            ExceptionQueuedEvent event = (ExceptionQueuedEvent)i.next();
            ExceptionQueuedEventContext context = (ExceptionQueuedEventContext)event.getSource();
            if (null != context) {
                Throwable t = context.getException();
                if (null != t) {
                    String errorView = this.getErrorView(t, errorViews);
                    if (null != errorView) {
                        FacesContext fc = FacesContext.getCurrentInstance();
                        NavigationHandler nav = fc.getApplication().getNavigationHandler();
                        try {
                            nav.handleNavigation(fc, null, errorView);
                            fc.renderResponse();
                            continue;
                        }
                        finally {
                            i.remove();
                            continue;
                        }
                    }
                    logger.log(BridgeLogger.Level.ERROR, "No error mapping found in web.xml for Throwable: " + t.getClass().getName());
                    continue;
                }
                logger.log(BridgeLogger.Level.ERROR, "Null exception found on ExceptionQueuedEventContext in Phase: " + context.getPhaseId() + " and Component:" + context.getComponent());
                continue;
            }
            logger.log(BridgeLogger.Level.ERROR, "ExceptionQueuedEventContext null for ExceptionQueuedEvent: " + event.toString());
        }
        this.getWrapped().handle();
    }

    protected String getErrorView(Throwable t, Map<Class<? extends Throwable>, String> errorViews) {
        Throwable cause = this.getCause(t);
        String errorView = null;
        if (null != cause && null != (errorView = this.getErrorView(cause, errorViews))) {
            return errorView;
        }
        for (Class<? extends Throwable> errorClass : errorViews.keySet()) {
            if (!errorClass.isInstance(t) || !errorViews.containsKey(errorClass)) continue;
            errorView = errorViews.get(errorClass);
        }
        return errorView;
    }

    protected Throwable getCause(Throwable exception) {
        Throwable cause = null;
        cause = exception instanceof ServletException ? ((ServletException)exception).getRootCause() : exception.getCause();
        return cause;
    }
}

