/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.context;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.StateAwareResponse;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import org.jboss.portletbridge.context.PortalActionURL;
import org.jboss.portletbridge.context.PortalUrlQueryString;
import org.jboss.portletbridge.context.PortletExternalContextImpl;

public class ActionRequestExternalContextImpl
extends PortletExternalContextImpl {
    public ActionRequestExternalContextImpl(PortletContext context, ActionRequest request, ActionResponse response) {
        super(context, (PortletRequest)request, (PortletResponse)response);
    }

    @Override
    public PortletContext getContext() {
        return super.getContext();
    }

    public ActionRequest getActionRequest() {
        return (ActionRequest)super.getRequest();
    }

    public ActionResponse getActionResponse() {
        return (ActionResponse)super.getResponse();
    }

    @Override
    protected String createActionUrl(PortalActionURL actionUrl, boolean escape) {
        String viewIdFromUrl = this.bridgeContext.getFacesViewIdFromPath(actionUrl.getPath());
        actionUrl.setParameter(this.bridgeContext.getBridgeConfig().getViewIdRenderParameterName(), viewIdFromUrl);
        StateAwareResponse stateResponse = (StateAwareResponse)this.getResponse();
        for (Map.Entry<String, String[]> parameter : actionUrl.getParameters().entrySet()) {
            String key = parameter.getKey();
            String[] value = parameter.getValue();
            if (key.equals("javax.portlet.faces.PortletMode")) {
                if (null == value) continue;
                PortletMode mode = new PortletMode(value[0]);
                try {
                    stateResponse.setPortletMode(mode);
                }
                catch (PortletModeException e) {}
                continue;
            }
            if (key.equals("javax.portlet.faces.WindowState")) {
                if (null == value) continue;
                WindowState state = new WindowState(value[0]);
                try {
                    stateResponse.setWindowState(state);
                }
                catch (WindowStateException e) {}
                continue;
            }
            if (key.equals("javax.portlet.faces.Secure")) continue;
            stateResponse.setRenderParameter(key, value);
        }
        return this.escapeUrl(escape, actionUrl.toString());
    }

    @Override
    protected String createPartialActionUrl(PortalActionURL portalUrl) {
        return this.createActionUrl(portalUrl, this.isStrictEscaped(portalUrl.toString()));
    }

    @Override
    protected String createRenderUrl(PortalActionURL portalUrl, boolean escape, Map<String, List<String>> parameters) {
        return "/JBossPortletBridge/actionUrl/do/nothing";
    }

    @Override
    protected String createResourceUrl(PortalActionURL portalUrl, boolean escape) {
        return "/JBossPortletBridge/resourceUrl/do/nothing";
    }

    @Override
    public void redirect(String url) throws IOException {
        if (null == url || url.length() < 0) {
            throw new IllegalArgumentException("Path to redirect is null");
        }
        PortalActionURL actionURL = new PortalActionURL(url);
        Map urlParams = null;
        if (null != this.encodedActionUrlParameters) {
            urlParams = (Map)this.encodedActionUrlParameters.get(url);
        }
        if (null != urlParams) {
            PortalUrlQueryString queryString = new PortalUrlQueryString(null);
            queryString.setParameters(urlParams);
            Map publicParamMap = this.getActionRequest().getPublicParameterMap();
            if (null != publicParamMap && !publicParamMap.isEmpty()) {
                for (Map.Entry entry : publicParamMap.entrySet()) {
                    String key = (String)entry.getKey();
                    if (queryString.hasParameter(key)) continue;
                    for (String param : (String[])entry.getValue()) {
                        queryString.addParameter(key, param);
                    }
                }
            }
            this.bridgeContext.setRenderRedirectQueryString(queryString.toString());
        } else if (url.startsWith("#") || !actionURL.isInContext(this.getRequestContextPath()) || "true".equalsIgnoreCase(actionURL.getParameter("javax.portlet.faces.DirectLink"))) {
            this.getPortletFlash().doLastPhaseActions(FacesContext.getCurrentInstance(), true);
            this.getActionResponse().sendRedirect(url);
        } else {
            this.redirect(this.encodeActionURL(url));
        }
        FacesContext context = FacesContext.getCurrentInstance();
        this.getPortletFlash().doLastPhaseActions(context, true);
        context.responseComplete();
    }

    @Override
    public String getRequestContentType() {
        return this.getActionRequest().getContentType();
    }

    public int getRequestContentLength() {
        return this.getActionRequest().getContentLength();
    }

    @Override
    public void setRequestCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        try {
            this.getActionRequest().setCharacterEncoding(encoding);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public String getRequestCharacterEncoding() {
        return this.getActionRequest().getCharacterEncoding();
    }

    @Override
    protected String getRequestHeader(String name) {
        if ("CONTENT-TYPE".equalsIgnoreCase(name)) {
            if (null == this.contentType) {
                this.constructContentType();
            }
            return this.contentType;
        }
        if ("CONTENT-LENGTH".equalsIgnoreCase(name)) {
            if (null == this.contentLength) {
                this.constructContentLength();
            }
            return this.contentLength;
        }
        return super.getRequestHeader(name);
    }

    @Override
    protected Enumeration<String> getRequestHeaderNames() {
        ArrayList<String> names = new ArrayList<String>();
        Enumeration<String> propNames = super.getRequestHeaderNames();
        while (propNames.hasMoreElements()) {
            String name = propNames.nextElement();
            names.add(name);
        }
        names.add("CONTENT-TYPE");
        names.add("CONTENT-LENGTH");
        return Collections.enumeration(names);
    }

    @Override
    protected String[] getRequestHeaderValues(String name) {
        if ("CONTENT-TYPE".equalsIgnoreCase(name)) {
            if (null == this.contentType) {
                this.constructContentType();
            }
            return new String[]{this.contentType};
        }
        if ("CONTENT-LENGTH".equalsIgnoreCase(name)) {
            if (null == this.contentLength) {
                this.constructContentLength();
            }
            return new String[]{this.contentLength};
        }
        return super.getRequestHeaderValues(name);
    }

    public void addResponseHeader(String name, String value) {
        if ("X-Portlet-Mode".equals(name)) {
            try {
                this.getActionResponse().setPortletMode(new PortletMode(value));
            }
            catch (PortletModeException e) {
                throw new RuntimeException("Cant set portlet mode '" + value + "'", e);
            }
        } else if ("X-Window-State".equals(name)) {
            try {
                this.getActionResponse().setWindowState(new WindowState(value));
            }
            catch (WindowStateException e) {
                throw new RuntimeException("Cant set window state '" + value + "'", e);
            }
        } else {
            super.addResponseHeader(name, value);
        }
    }

    public void setResponseHeader(String name, String value) {
        if ("X-Portlet-Mode".equals(name)) {
            try {
                this.getActionResponse().setPortletMode(new PortletMode(value));
            }
            catch (PortletModeException e) {
                throw new RuntimeException("Cant set portlet mode '" + value + "'", e);
            }
        } else if ("X-Window-State".equals(name)) {
            try {
                this.getActionResponse().setWindowState(new WindowState(value));
            }
            catch (WindowStateException e) {
                throw new RuntimeException("Cant set window state '" + value + "'", e);
            }
        } else {
            super.setResponseHeader(name, value);
        }
    }

    public boolean isResponseCommitted() {
        return false;
    }

    public void responseSendError(int statusCode, String message) throws IOException {
    }

    public int getResponseBufferSize() {
        return 0;
    }

    public OutputStream getResponseOutputStream() throws IOException {
        return null;
    }

    public Writer getResponseOutputWriter() throws IOException {
        return null;
    }

    public void responseFlushBuffer() throws IOException {
        this.getPortletFlash().doLastPhaseActions(FacesContext.getCurrentInstance(), true);
    }

    public void responseReset() {
    }

    public void setResponseBufferSize(int size) {
    }

    public void setResponseContentLength(int length) {
    }

    public void setResponseContentType(String contentType) {
    }
}

