/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import javax.portlet.PortletContext;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jboss.portletbridge.config.FacesConfigHandler;
import org.jboss.portletbridge.config.ParsingException;
import org.jboss.portletbridge.config.WebXmlProcessor;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class FacesConfigProcessor
implements SystemEventListener {
    private static final Logger logger = Logger.getLogger(FacesConfigProcessor.class.getName(), "org.jboss.portletbridge.LogMessages");
    private static SAXParserFactory saxFactory = SAXParserFactory.newInstance();
    private static final String FACES_CONFIG_CLASS_PATH = "META-INF/faces-config.xml";
    private static final String FACES_CONFIG_WEB_PATH = "/WEB-INF/faces-config.xml";
    private static boolean scanned;
    private static List<String> excludedAttributes;
    private static Map<String, String> publicParameterMapping;
    private static String writeBehindRenderResponseWrapper;
    private static String writeBehindResourceResponseWrapper;

    public static List<String> getExcludedAttributes() {
        return excludedAttributes;
    }

    public static Map<String, String> getPublicParameterMappings() {
        return publicParameterMapping;
    }

    public static String getWriteBehindRenderResponseWrapperClassName() {
        return writeBehindRenderResponseWrapper;
    }

    public static String getWriteBehindResourceResponseWrapperClassName() {
        return writeBehindResourceResponseWrapper;
    }

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        if (!scanned) {
            try {
                this.parseClasspath();
                this.parseDefault();
            }
            catch (ParsingException e) {
                throw new FacesException("Portlet Bridge error parsing faces-config(s)", (Throwable)e);
            }
            scanned = true;
        }
    }

    public boolean isListenerForSource(Object source) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseClasspath() throws ParsingException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (null == classLoader) {
            classLoader = FacesContext.getCurrentInstance().getExternalContext().getClass().getClassLoader();
        }
        try {
            Enumeration<URL> resources = classLoader.getResources(FACES_CONFIG_CLASS_PATH);
            while (resources.hasMoreElements()) {
                URL resourceURL = resources.nextElement();
                try {
                    URLConnection connection = resourceURL.openConnection();
                    connection.setUseCaches(false);
                    InputStream inputStream = connection.getInputStream();
                    try {
                        this.parse(inputStream, ParsingLocation.CLASSPATH);
                    }
                    finally {
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Can't parse " + resourceURL.toExternalForm(), e);
                }
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Can't get META-INF/faces-config.xml resources", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseDefault() throws ParsingException {
        InputStream inputStream = FacesContext.getCurrentInstance().getExternalContext().getResourceAsStream(FACES_CONFIG_WEB_PATH);
        if (null != inputStream) {
            try {
                this.parse(inputStream, ParsingLocation.DEFAULT);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Can't close input stream for web resource /WEB-INF/faces-config.xml", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseOptional(PortletContext context) throws ParsingException {
        String facesConfigs = context.getInitParameter("javax.faces.CONFIG_FILES");
        if (null != facesConfigs) {
            String[] configNamesArray = facesConfigs.trim().split("(\\s)*,(\\s)*");
            for (int i = 0; i < configNamesArray.length; ++i) {
                String facesConfigPath = configNamesArray[i];
                InputStream inputStream = context.getResourceAsStream(facesConfigPath);
                if (null == inputStream) continue;
                try {
                    this.parse(inputStream, ParsingLocation.OPTIONAL);
                    continue;
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        logger.log(Level.WARNING, "Can't close input stream for web resource " + facesConfigPath, e);
                    }
                }
            }
        }
    }

    protected void parse(InputStream facesConfig, ParsingLocation location) throws ParsingException {
        try {
            SAXParser parser = saxFactory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            FacesConfigHandler facesConfigHandler = new FacesConfigHandler(reader);
            reader.setContentHandler(facesConfigHandler);
            reader.setEntityResolver(WebXmlProcessor.NULL_RESOLVER);
            reader.setErrorHandler(facesConfigHandler);
            reader.setDTDHandler(facesConfigHandler);
            reader.parse(new InputSource(facesConfig));
            excludedAttributes.addAll(facesConfigHandler.getExcludedAttributes());
            publicParameterMapping.putAll(facesConfigHandler.getParameterMapping());
            if (location.equals((Object)ParsingLocation.CLASSPATH) || location.equals((Object)ParsingLocation.DEFAULT)) {
                writeBehindRenderResponseWrapper = facesConfigHandler.getRenderResponseWrapperClass();
                writeBehindResourceResponseWrapper = facesConfigHandler.getResourceResponseWrapperClass();
            } else if (location.equals((Object)ParsingLocation.OPTIONAL)) {
                if (null == writeBehindRenderResponseWrapper) {
                    writeBehindRenderResponseWrapper = facesConfigHandler.getRenderResponseWrapperClass();
                }
                if (null == writeBehindResourceResponseWrapper) {
                    writeBehindResourceResponseWrapper = facesConfigHandler.getResourceResponseWrapperClass();
                }
            }
        }
        catch (ParserConfigurationException e) {
            throw new ParsingException("SAX Parser configuration error", e);
        }
        catch (SAXException e) {
            logger.log(Level.WARNING, "Exception at faces-config.xml parsing", e);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Exception at faces-config.xml parsing", e);
        }
    }

    static {
        saxFactory.setValidating(false);
        saxFactory.setNamespaceAware(true);
        scanned = false;
        excludedAttributes = new ArrayList<String>();
        publicParameterMapping = new HashMap<String, String>();
        writeBehindRenderResponseWrapper = null;
        writeBehindResourceResponseWrapper = null;
    }

    static enum ParsingLocation {
        CLASSPATH,
        OPTIONAL,
        DEFAULT;

    }
}

