/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.bridge.scope;

import java.util.List;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.portlet.PortalContext;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.faces.annotation.ExcludeFromManagedRequestScope;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpSession;

public class BridgeRequestScopeUtil {
    private BridgeRequestScopeUtil() {
    }

    public static boolean isExcluded(String key, Object value, List<String> localExcludes) {
        return null != value && BridgeRequestScopeUtil.isExcludedBean(value) || null != localExcludes && localExcludes.contains(key) || BridgeRequestScopeUtil.isExcludedByDefinition(key, value) || BridgeRequestScopeUtil.isExcludedNamespace(key, localExcludes);
    }

    public static boolean isExcludedByDefinition(String key, Object value) {
        if (null != value && (value instanceof PortletConfig || value instanceof PortletContext || value instanceof PortletRequest || value instanceof PortletResponse || value instanceof PortletSession || value instanceof PortletPreferences || value instanceof PortalContext || value instanceof FacesContext || value instanceof ExternalContext || value instanceof ServletConfig || value instanceof ServletContext || value instanceof ServletRequest || value instanceof ServletResponse || value instanceof HttpSession)) {
            return true;
        }
        return BridgeRequestScopeUtil.isNamespaceMatch(key, "javax.portlet.") || BridgeRequestScopeUtil.isNamespaceMatch(key, "javax.portlet.faces.") || BridgeRequestScopeUtil.isNamespaceMatch(key, "javax.faces.") || BridgeRequestScopeUtil.isNamespaceMatch(key, "javax.servlet.") || BridgeRequestScopeUtil.isNamespaceMatch(key, "javax.servlet.include.") || BridgeRequestScopeUtil.isNamespaceMatch(key, "org.jboss.portletbridge.REQUEST_PARAMETERS");
    }

    public static boolean isExcludedBean(Object bean) {
        return bean.getClass().isAnnotationPresent(ExcludeFromManagedRequestScope.class);
    }

    public static boolean isExcludedNamespace(String key, List<String> localExcludes) {
        if (null == localExcludes) {
            return false;
        }
        if (localExcludes.contains(key)) {
            return true;
        }
        for (String exclude : localExcludes) {
            if (!exclude.endsWith("*") || !BridgeRequestScopeUtil.isNamespaceMatch(key, exclude.substring(0, exclude.length() - 1))) continue;
            return true;
        }
        return false;
    }

    public static boolean isNamespaceMatch(String key, String namespace) {
        if (null != key && null != namespace && key.startsWith(namespace)) {
            key = key.substring(0, key.lastIndexOf(46) + 1);
            return key.equals(namespace);
        }
        return false;
    }

    public static String generateBridgeRequestScopeIdPrefix(String portletName, String sessionId, String viewId, String portletMode) {
        return new StringBuffer(portletName).append(':').append(sessionId).append(':').append(viewId).append(':').append(portletMode).toString();
    }
}

