/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.coordinator;

import com.arjuna.ats.arjuna.coordinator.Reapable;
import com.arjuna.ats.arjuna.logging.tsLogger;
import java.util.concurrent.atomic.AtomicInteger;

public class ReaperElement
implements Comparable<ReaperElement> {
    public final Reapable _control;
    private long _nextCheckAbsoluteMillis;
    private long _transactionTimeoutAbsoluteMillis;
    private final int _bias;
    private static final int MAX_BIAS = 1000000;
    private static final AtomicInteger biasCounter = new AtomicInteger();
    public int _timeout;
    public int _status;
    public Thread _worker;
    public static final int RUN = 0;
    public static final int SCHEDULE_CANCEL = 1;
    public static final int CANCEL = 2;
    public static final int CANCEL_INTERRUPTED = 3;
    public static final int FAIL = 4;
    public static final int COMPLETE = 5;
    public static final int ZOMBIE = 6;
    public static final int TRACE = 7;

    public ReaperElement(Reapable control, int cancelIntervalSeconds) {
        this(control, cancelIntervalSeconds, Long.MAX_VALUE);
    }

    public ReaperElement(Reapable control, int cancelIntervalSeconds, long traceGracePeriodMills) {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("ReaperElement::ReaperElement ( " + control + ", " + cancelIntervalSeconds + " )"));
        }
        this._control = control;
        this._timeout = cancelIntervalSeconds;
        this._status = 0;
        this._worker = null;
        long now = System.currentTimeMillis();
        this._nextCheckAbsoluteMillis = this._transactionTimeoutAbsoluteMillis = (long)cancelIntervalSeconds * 1000L + now;
        if (traceGracePeriodMills < (long)cancelIntervalSeconds * 1000L) {
            this._nextCheckAbsoluteMillis = traceGracePeriodMills + now;
        }
        this._bias = ReaperElement.getBiasCounter();
    }

    public String toString() {
        return "ReaperElement < " + this._control + ", " + this._timeout + ", " + this.statusName() + ", " + this._worker + " >";
    }

    @Override
    public int compareTo(ReaperElement other) {
        if (this == other) {
            return 0;
        }
        if (this._nextCheckAbsoluteMillis == other._nextCheckAbsoluteMillis) {
            if (this._bias == other._bias) {
                if (this._control.get_uid().equals(other._control.get_uid())) {
                    return 0;
                }
                if (this._control.get_uid().greaterThan(other._control.get_uid())) {
                    return 1;
                }
                return -1;
            }
            return this._bias > other._bias ? 1 : -1;
        }
        return this._nextCheckAbsoluteMillis > other._nextCheckAbsoluteMillis ? 1 : -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReaperElement that = (ReaperElement)o;
        return this.compareTo(that) == 0;
    }

    public int hashCode() {
        return this._control.get_uid().hashCode();
    }

    private static int getBiasCounter() {
        int value = 0;
        do {
            if ((value = biasCounter.getAndIncrement()) != 1000000) continue;
            biasCounter.set(0);
        } while (value >= 1000000);
        return value;
    }

    public final String statusName() {
        switch (this._status) {
            case 0: {
                return "RUN";
            }
            case 1: {
                return "SCHEDULE_CANCEL";
            }
            case 2: {
                return "CANCEL";
            }
            case 3: {
                return "CANCEL_INTERRUPTED";
            }
            case 4: {
                return "FAIL";
            }
            case 5: {
                return "COMPLETE";
            }
            case 6: {
                return "ZOMBIE";
            }
            case 7: {
                return "TRACE";
            }
        }
        return "UNKNOWN";
    }

    public long getNextCheckAbsoluteMillis() {
        return this._nextCheckAbsoluteMillis;
    }

    public void setNextCheckAbsoluteMillis(long nextCheckAbsoluteMillis) {
        this._nextCheckAbsoluteMillis = nextCheckAbsoluteMillis;
    }

    public long getTransactionTimeoutAbsoluteMillis() {
        return this._transactionTimeoutAbsoluteMillis;
    }
}

