/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.transformer;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.jboss.maven.plugins.transformer.Action;
import org.jboss.maven.plugins.transformer.TransformerUtils;

public class TransformerMojo
extends AbstractMojo {
    protected MavenProject project;
    protected String filterPattern;
    protected String transformerClassName;
    protected String output;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Transforming classes: filter = " + this.filterPattern + ", transformer = " + this.transformerClassName + ", output = " + this.output));
        final TransformerUtils utils = new TransformerUtils();
        utils.setTransformerClassName(this.transformerClassName);
        utils.setFilterPattern(this.filterPattern);
        try {
            final boolean isTest = "test".equals(this.output);
            utils.execute(this.buildProjectCompileClassLoader(isTest), new Action(){

                @Override
                public void execute() throws Exception {
                    Build build = TransformerMojo.this.project.getBuild();
                    String output = isTest ? build.getTestOutputDirectory() : build.getOutputDirectory();
                    File outputDir = new File(output);
                    utils.recurse(outputDir, "");
                }
            });
        }
        catch (Exception e) {
            throw new MojoExecutionException("Cannot execute transformation.", e);
        }
    }

    private ClassLoader buildProjectCompileClassLoader(boolean isTest) throws MojoExecutionException {
        ArrayList<URL> classPathUrls = new ArrayList<URL>();
        for (String path : this.projectCompileClasspathElements(isTest)) {
            try {
                this.getLog().info((CharSequence)("Adding project compile classpath element : " + path));
                classPathUrls.add(new File(path).toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Unable to build path URL [" + path + "]");
            }
        }
        return new URLClassLoader(classPathUrls.toArray(new URL[classPathUrls.size()]), ((Object)((Object)this)).getClass().getClassLoader());
    }

    private List<String> projectCompileClasspathElements(boolean isTest) throws MojoExecutionException {
        try {
            if (isTest) {
                return this.project.getTestClasspathElements();
            }
            return this.project.getCompileClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Call to MavenProject#getCompileClasspathElements required dependency resolution");
        }
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public String getFilterPattern() {
        return this.filterPattern;
    }

    public void setFilterPattern(String filterPattern) {
        this.filterPattern = filterPattern;
    }

    public String getTransformerClassName() {
        return this.transformerClassName;
    }

    public void setTransformerClassName(String transformerClassName) {
        this.transformerClassName = transformerClassName;
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = output;
    }
}

