/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.model;

import com.sun.codemodel.internal.JBlock;
import com.sun.codemodel.internal.JCodeModel;
import com.sun.codemodel.internal.JDefinedClass;
import com.sun.codemodel.internal.JMethod;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.LoggingTools;
import org.jboss.logging.model.ClassModel;

public class MessageLoggerTranslator
extends ClassModel {
    private static final String LOGGER_PARAMETER_NAME = "logger";
    private final Map<String, String> translations;

    public MessageLoggerTranslator(String className, String superClassName, Map<String, String> translations) {
        super(className, superClassName);
        this.translations = translations != null ? translations : Collections.emptyMap();
    }

    @Override
    public JCodeModel generateModel() throws IllegalStateException {
        JCodeModel model = super.generateModel();
        JDefinedClass definedClass = this.getDefinedClass();
        JMethod constructor = definedClass.constructor(2);
        constructor.param(8, LoggingTools.findLoggers().loggerClass(), LOGGER_PARAMETER_NAME);
        JBlock constructorBody = constructor.body();
        constructorBody.directStatement("super(logger);");
        Set<Map.Entry<String, String>> entries = this.translations.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String key = entry.getKey();
            String value = entry.getValue();
            JMethod method = this.addMessageMethod(key, value);
            method.annotate(Override.class);
        }
        return model;
    }
}

