/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.model;

import com.sun.codemodel.internal.JBlock;
import com.sun.codemodel.internal.JClass;
import com.sun.codemodel.internal.JCodeModel;
import com.sun.codemodel.internal.JExpr;
import com.sun.codemodel.internal.JExpression;
import com.sun.codemodel.internal.JFieldVar;
import com.sun.codemodel.internal.JInvocation;
import com.sun.codemodel.internal.JMethod;
import com.sun.codemodel.internal.JType;
import com.sun.codemodel.internal.JVar;
import org.jboss.logging.generator.MethodDescriptor;
import org.jboss.logging.generator.MethodParameter;
import org.jboss.logging.model.ClassModelUtil;
import org.jboss.logging.model.ImplementationClassModel;
import org.jboss.logging.model.ImplementationType;

public class MessageBundleImplementor
extends ImplementationClassModel {
    public MessageBundleImplementor(String interfaceName, String projectCode) {
        super(interfaceName, projectCode, ImplementationType.BUNDLE);
    }

    @Override
    protected JCodeModel generateModel() throws IllegalStateException {
        JCodeModel codeModel = super.generateModel();
        JFieldVar projectCodeVar = null;
        if (!this.getProjectCode().isEmpty()) {
            projectCodeVar = this.getDefinedClass().field(28, String.class, "projectCode");
            projectCodeVar.init(JExpr.lit((String)this.getProjectCode()));
        }
        this.getDefinedClass().constructor(2);
        ClassModelUtil.createReadResolveMethod(this.getDefinedClass());
        for (MethodDescriptor methodDesc : this.methodDescriptor) {
            String formattedId;
            JClass returnType = codeModel.ref(methodDesc.returnType().getReturnTypeAsString());
            JMethod jMethod = this.getDefinedClass().method(9, (JType)returnType, methodDesc.name());
            jMethod.annotate(Override.class);
            JMethod msgMethod = this.addMessageMethod(methodDesc.name(), methodDesc.messageValue());
            JBlock body = jMethod.body();
            JClass returnField = codeModel.ref(returnType.fullName());
            JVar result = body.decl((JType)returnField, "result");
            JClass formatter = codeModel.ref(methodDesc.messageFormat().formatClass());
            JInvocation formatterMethod = formatter.staticInvoke(methodDesc.messageFormat().staticMethod());
            if (methodDesc.parameters().isEmpty()) {
                if (methodDesc.returnType().isException()) {
                    if (methodDesc.hasMessageId() && projectCodeVar != null) {
                        formattedId = String.format("%05d: ", methodDesc.messageId());
                        formatterMethod.arg(projectCodeVar.plus(JExpr.lit((String)formattedId)).plus((JExpression)JExpr.invoke((JMethod)msgMethod)));
                        this.initCause(result, returnField, body, methodDesc, formatterMethod);
                    } else {
                        this.initCause(result, returnField, body, methodDesc, JExpr.invoke((JMethod)msgMethod));
                    }
                } else {
                    result.init((JExpression)JExpr.invoke((JMethod)msgMethod));
                }
            } else {
                if (methodDesc.hasMessageId() && projectCodeVar != null) {
                    formattedId = String.format("%05d: ", methodDesc.messageId());
                    formatterMethod.arg(projectCodeVar.plus(JExpr.lit((String)formattedId)).plus((JExpression)JExpr.invoke((JMethod)msgMethod)));
                } else {
                    formatterMethod.arg((JExpression)JExpr.invoke((JMethod)msgMethod));
                }
                for (MethodParameter param : methodDesc.parameters()) {
                    JClass paramType = codeModel.ref(param.fullType());
                    JVar paramVar = jMethod.param(8, (JType)paramType, param.name());
                    if (param.isCause()) continue;
                    String formatterClass = param.getFormatterClass();
                    if (formatterClass == null) {
                        formatterMethod.arg((JExpression)paramVar);
                        continue;
                    }
                    formatterMethod.arg((JExpression)JExpr._new((JType)JClass.parse((JCodeModel)codeModel, (String)formatterClass)).arg((JExpression)paramVar));
                }
                if (methodDesc.returnType().isException()) {
                    this.initCause(result, returnField, body, methodDesc, formatterMethod);
                } else {
                    result.init((JExpression)formatterMethod);
                }
            }
            body._return((JExpression)result);
        }
        return codeModel;
    }
}

