/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import org.jboss.logging.AbstractTool;
import org.jboss.logging.Annotations;
import org.jboss.logging.Loggers;
import org.jboss.logging.LoggingTools;
import org.jboss.logging.ToolLogger;
import org.jboss.logging.generator.ImplementorClassGenerator;
import org.jboss.logging.generator.TranslationClassGenerator;
import org.jboss.logging.generator.TranslationFileGenerator;
import org.jboss.logging.util.ElementHelper;
import org.jboss.logging.validation.ValidationMessage;
import org.jboss.logging.validation.Validator;

@SupportedAnnotationTypes(value={"*"})
@SupportedOptions(value={"debug"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class LoggingToolsProcessor
extends AbstractProcessor {
    public static final String DEBUG_OPTION = "debug";
    private final List<AbstractTool> processors = new ArrayList<AbstractTool>();
    private Annotations annotations;
    private Loggers loggers;
    private ToolLogger logger;

    @Override
    public void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.logger = ToolLogger.getLogger(processingEnv);
        this.annotations = LoggingTools.findAnnotations();
        this.loggers = LoggingTools.findLoggers();
        this.processors.add(new ImplementorClassGenerator(processingEnv, this.annotations, this.loggers));
        this.processors.add(new TranslationClassGenerator(processingEnv, this.annotations, this.loggers));
        this.processors.add(new TranslationFileGenerator(processingEnv, this.annotations, this.loggers));
    }

    @Override
    public Set<String> getSupportedOptions() {
        HashSet<String> supportedOptions = new HashSet<String>();
        SupportedOptions globalOptions = this.getClass().getAnnotation(SupportedOptions.class);
        if (globalOptions != null) {
            supportedOptions.addAll(Arrays.asList(globalOptions.value()));
        }
        for (AbstractTool generator : this.processors) {
            supportedOptions.addAll(generator.getSupportedOptions());
        }
        return supportedOptions;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        boolean process = true;
        Types typesUtil = this.processingEnv.getTypeUtils();
        Validator validator = Validator.buildValidator(this.processingEnv, this.annotations);
        for (TypeElement typeElement : annotations) {
            if (!this.isValidAnnotation(typeElement)) continue;
            Set<TypeElement> elements = ElementFilter.typesIn(roundEnv.getElementsAnnotatedWith(typeElement));
            Collection<ValidationMessage> errorMessages = validator.validate(elements);
            for (ValidationMessage error : errorMessages) {
                if (error.type() == ValidationMessage.MessageType.ERROR) {
                    this.logger.error(error.getElement(), error.getMessage(), new Object[0]);
                    process = false;
                    continue;
                }
                this.logger.warn(error.getElement(), error.getMessage(), new Object[0]);
            }
            if (!process) continue;
            for (TypeElement element : elements) {
                if (!element.getKind().isInterface() || element.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
                Collection<ExecutableElement> methods = ElementHelper.getInterfaceMethods(element, typesUtil, this.loggers);
                for (AbstractTool processor : this.processors) {
                    this.logger.debug("Executing processor %s", processor.getName());
                    processor.processTypeElement(typeElement, element, methods);
                }
            }
        }
        return process;
    }

    private boolean isValidAnnotation(TypeElement annotation) {
        String name = annotation.getQualifiedName().toString();
        return name.equals(this.annotations.messageBundle().getName()) || name.equals(this.annotations.messageLogger().getName());
    }
}

