/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.jmx.compliance.openmbean;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularData;
import junit.framework.TestCase;

public class OpenTypeTestCase
extends TestCase {
    public OpenTypeTestCase(String s) {
        super(s);
    }

    public void testAllowedClasses() throws Exception {
        String[] allowedClassNames = OpenType.ALLOWED_CLASSNAMES;
        OpenTypeTestCase.assertEquals((int)16, (int)allowedClassNames.length);
        List<String> names = Arrays.asList(allowedClassNames);
        this.checkOpenType(names, Void.class);
        this.checkOpenType(names, Boolean.class);
        this.checkOpenType(names, Character.class);
        this.checkOpenType(names, Byte.class);
        this.checkOpenType(names, Short.class);
        this.checkOpenType(names, Integer.class);
        this.checkOpenType(names, Long.class);
        this.checkOpenType(names, Float.class);
        this.checkOpenType(names, Double.class);
        this.checkOpenType(names, String.class);
        this.checkOpenType(names, Date.class);
        this.checkOpenType(names, BigDecimal.class);
        this.checkOpenType(names, BigInteger.class);
        this.checkOpenType(names, ObjectName.class);
        this.checkOpenType(names, CompositeData.class);
        this.checkOpenType(names, TabularData.class);
    }

    public void testConstructorSimple() throws Exception {
        MyOpenType test = new MyOpenType("java.lang.Void", "type", "description");
        OpenTypeTestCase.assertEquals((String)"java.lang.Void", (String)test.getClassName());
        OpenTypeTestCase.assertEquals((String)"type", (String)test.getTypeName());
        OpenTypeTestCase.assertEquals((String)"description", (String)test.getDescription());
        OpenTypeTestCase.assertEquals((boolean)false, (boolean)test.isArray());
    }

    public void testConstructorArray() throws Exception {
        MyOpenType test = new MyOpenType("[[Ljava.lang.Void;", "type", "description");
        OpenTypeTestCase.assertEquals((String)"[[Ljava.lang.Void;", (String)test.getClassName());
        OpenTypeTestCase.assertEquals((String)"type", (String)test.getTypeName());
        OpenTypeTestCase.assertEquals((String)"description", (String)test.getDescription());
        OpenTypeTestCase.assertEquals((boolean)true, (boolean)test.isArray());
    }

    public void testSerializationSimple() throws Exception {
        this.testSerialization("java.lang.Void", "type", "description");
    }

    public void testSerializationArray() throws Exception {
        this.testSerialization("[[Ljava.lang.Void;", "type", "description");
    }

    public void testErrors() throws Exception {
        boolean caught = false;
        try {
            new MyOpenType(null, "dummy", "dummy");
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        OpenTypeTestCase.assertTrue((String)"className cannot be null", (boolean)caught);
        caught = false;
        try {
            new MyOpenType("", "dummy", "dummy");
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        OpenTypeTestCase.assertTrue((String)"className cannot be empty", (boolean)caught);
        caught = false;
        try {
            new MyOpenType("java.lang.Void", null, "dummy");
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        OpenTypeTestCase.assertTrue((String)"typeName cannot be null", (boolean)caught);
        caught = false;
        try {
            new MyOpenType("java.lang.Void", null, "dummy");
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        OpenTypeTestCase.assertTrue((String)"typeName cannot be empty", (boolean)caught);
        caught = false;
        try {
            new MyOpenType("java.lang.Void", "dummy", null);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        OpenTypeTestCase.assertTrue((String)"description cannot be null", (boolean)caught);
        caught = false;
        try {
            new MyOpenType("java.lang.Void", "dummy", "");
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        OpenTypeTestCase.assertTrue((String)"description cannot be empty", (boolean)caught);
        caught = false;
        try {
            new MyOpenType("java.lang.Class", "dummy", "dummy");
        }
        catch (OpenDataException e) {
            caught = true;
        }
        OpenTypeTestCase.assertTrue((String)"className must be an OpenDataType", (boolean)caught);
        caught = false;
        try {
            new MyOpenType("[Ljava.lang.Void", "dummy", "dummy");
        }
        catch (OpenDataException e) {
            caught = true;
        }
        OpenTypeTestCase.assertTrue((String)"[Ljava.lang.Void is not a valid array", (boolean)caught);
    }

    public void testErrors2() throws Exception {
        boolean caught = false;
        try {
            new MyOpenType("[L", "dummy", "dummy");
        }
        catch (StringIndexOutOfBoundsException e) {
            OpenTypeTestCase.fail((String)"FAILS IN RI: [L open type should be an OpenDataException not a StringIndexOutOfBoundsException");
        }
        catch (OpenDataException e) {
            caught = true;
        }
        OpenTypeTestCase.assertTrue((String)"[L is not a valid array", (boolean)caught);
    }

    public void testErrors3() throws Exception {
        boolean caught = false;
        try {
            new MyOpenType("[Xjava.lang.Void;", "dummy", "dummy");
        }
        catch (OpenDataException e) {
            caught = true;
        }
        OpenTypeTestCase.assertTrue((String)"FAILS IN RI: [Xjava.lang.Void; is not a valid array", (boolean)caught);
    }

    private void checkOpenType(List names, Class clazz) throws Exception {
        String name = clazz.getName();
        OpenTypeTestCase.assertTrue((String)(name + " is an OpenType"), (boolean)names.contains(name));
        new MyOpenType(name, "dummy", "dummy");
        new MyOpenType("[L" + name + ";", "dummy", "dummy");
        new MyOpenType("[[[[[L" + name + ";", "dummy", "dummy");
    }

    private void testSerialization(String className, String type, String description) throws Exception {
        MyOpenType original = new MyOpenType(className, type, description);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(original);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        OpenType result = (OpenType)ois.readObject();
        OpenTypeTestCase.assertEquals((String)original.getClassName(), (String)result.getClassName());
        OpenTypeTestCase.assertEquals((String)original.getTypeName(), (String)result.getTypeName());
        OpenTypeTestCase.assertEquals((String)original.getDescription(), (String)result.getDescription());
        OpenTypeTestCase.assertEquals((boolean)original.isArray(), (boolean)result.isArray());
    }

    public static class MyOpenType
    extends OpenType {
        private static final long serialVersionUID = -1L;

        public MyOpenType(String className, String typeName, String description) throws OpenDataException {
            super(className, typeName, description);
        }

        public boolean equals(Object other) {
            throw new UnsupportedOperationException("irrelevent");
        }

        public int hashCode() {
            throw new UnsupportedOperationException("irrelevent");
        }

        public boolean isValue(Object other) {
            throw new UnsupportedOperationException("irrelevent");
        }

        public String toString() {
            throw new UnsupportedOperationException("irrelevent");
        }
    }
}

