/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.jmx.compliance.objectname;

import javax.management.ObjectName;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class QuoteSUITE
extends TestSuite {
    private static final String EMPTY = "";
    private static final String WHITESPACE = " ";
    private static final String DOMAIN = "domain";
    private static final String LETTER = "A";
    private static final String QUOTE = "\"";
    private static final String ESCAPE = "\\";
    private static final String ASTERISK = "*";
    private static final String QUESTION = "?";
    private static final String NL = "\n";
    private static final String NEWLINE = "\\n";
    private static final String COLON = ":";
    private static final String COMMA = ",";
    private static final String EQUALS = "=";
    private static final String KEY = "type";
    private static final String VALUE = "user";
    private static final String JMI = "JMImplementation";
    private static final String TYPE = "type";
    private static final String DELEGATE = "MBeanServerDelegate";

    public static void main(String[] args) {
        TestRunner.run((Test)QuoteSUITE.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("All Quote Tests");
        suite.addTest((Test)new QuoteTEST(QUOTE, "\\\""));
        suite.addTest((Test)new QuoteTEST(ESCAPE, "\\\\"));
        suite.addTest((Test)new QuoteTEST(QUESTION, "\\?"));
        suite.addTest((Test)new QuoteTEST(ASTERISK, "\\*"));
        suite.addTest((Test)new QuoteTEST(NL, NEWLINE));
        suite.addTest((Test)new QuoteTEST(COLON, COLON));
        suite.addTest((Test)new QuoteTEST(COMMA, COMMA));
        suite.addTest((Test)new QuoteTEST(EQUALS, EQUALS));
        suite.addTest((Test)new QuoteTEST(EMPTY, EMPTY));
        suite.addTest((Test)new QuoteTEST(WHITESPACE, WHITESPACE));
        suite.addTest((Test)new QuoteTEST(LETTER, LETTER));
        suite.addTest((Test)new QuoteTEST("*:type=user,*", "\\*:type=user,\\*"));
        suite.addTest((Test)new QuoteTEST("JMImplementation:type=MBeanServerDelegate", "JMImplementation:type=MBeanServerDelegate"));
        suite.addTest((Test)new QuoteTEST("*:*", "\\*:\\*"));
        suite.addTest((Test)new UnquoteTEST("\\\"", QUOTE));
        suite.addTest((Test)new UnquoteTEST("\\\\", ESCAPE));
        suite.addTest((Test)new UnquoteTEST("\\?", QUESTION));
        suite.addTest((Test)new UnquoteTEST("\\*", ASTERISK));
        suite.addTest((Test)new UnquoteTEST(COLON, COLON));
        suite.addTest((Test)new UnquoteTEST(COMMA, COMMA));
        suite.addTest((Test)new UnquoteTEST(EQUALS, EQUALS));
        suite.addTest((Test)new UnquoteTEST(EMPTY, EMPTY));
        suite.addTest((Test)new UnquoteTEST(WHITESPACE, WHITESPACE));
        suite.addTest((Test)new UnquoteTEST(LETTER, LETTER));
        suite.addTest((Test)new UnquoteTEST("\\*:type=user,\\*", "*:type=user,*"));
        suite.addTest((Test)new UnquoteTEST("JMImplementation:type=MBeanServerDelegate", "JMImplementation:type=MBeanServerDelegate"));
        suite.addTest((Test)new UnquoteTEST("\\*:\\*", "*:*"));
        suite.addTest((Test)new UnquoteFailuresTEST(EMPTY));
        suite.addTest((Test)new UnquoteFailuresTEST("A\"A\""));
        suite.addTest((Test)new UnquoteFailuresTEST("\"A\"A"));
        suite.addTest((Test)new UnquoteFailuresTEST("\"A"));
        suite.addTest((Test)new UnquoteFailuresTEST("\"\"\""));
        suite.addTest((Test)new UnquoteFailuresTEST("\"\\\""));
        suite.addTest((Test)new UnquoteFailuresTEST("\"?\""));
        suite.addTest((Test)new UnquoteFailuresTEST("\"*\""));
        return suite;
    }

    public static class UnquoteFailuresTEST
    extends TestCase {
        private String test;

        public UnquoteFailuresTEST(String test) {
            super("testUnquoteFailures");
            this.test = test;
        }

        public void testUnquoteFailures() throws Exception {
            boolean caught = false;
            try {
                ObjectName.unquote(this.test);
            }
            catch (Exception e) {
                caught = true;
            }
            UnquoteFailuresTEST.assertTrue((String)("The value " + this.test + " should fail in unquote"), (boolean)caught);
        }
    }

    public static class UnquoteTEST
    extends TestCase {
        private String original;
        private String expectedResult;

        public UnquoteTEST(String original, String expectedResult) {
            super("testUnquote");
            this.original = QuoteSUITE.QUOTE + original + QuoteSUITE.QUOTE;
            this.expectedResult = expectedResult;
        }

        public void testUnquote() throws Exception {
            String unquoted = ObjectName.unquote(this.original);
            UnquoteTEST.assertTrue((String)("The unquoted string for " + this.original + " should be " + this.expectedResult + " but got " + unquoted), (boolean)this.expectedResult.equals(unquoted));
        }
    }

    public static class QuoteTEST
    extends TestCase {
        private String original;
        private String expectedResult;

        public QuoteTEST(String original, String expectedResult) {
            super("testQuote");
            this.original = original;
            this.expectedResult = QuoteSUITE.QUOTE + expectedResult + QuoteSUITE.QUOTE;
        }

        public void testQuote() throws Exception {
            String quoted = ObjectName.quote(this.original);
            QuoteTEST.assertTrue((String)("The quoted string for " + this.original + " should be " + this.expectedResult + " but got " + quoted), (boolean)this.expectedResult.equals(quoted));
            String quoteUnquote = ObjectName.unquote(quoted);
            QuoteTEST.assertTrue((String)("quote/unquote should produce the original string " + this.original + " but got " + quoteUnquote), (boolean)this.original.equals(quoteUnquote));
            new ObjectName(QuoteSUITE.DOMAIN, "type", quoted);
        }
    }
}

