/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jms.inflow;

import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.InvalidPropertyException;
import javax.resource.spi.ResourceAdapter;
import org.jboss.logging.Logger;
import org.jboss.util.Strings;

public class JmsActivationSpec
implements ActivationSpec {
    private static final Logger log = Logger.getLogger(JmsActivationSpec.class);
    private ResourceAdapter ra;
    private String destination;
    private String destinationType;
    private String messageSelector;
    private int acknowledgeMode;
    private boolean subscriptionDurability;
    private String clientId;
    private String subscriptionName;
    private long reconnectInterval = 10L;
    private String providerAdapterJNDI = "java:/DefaultJMSProvider";
    private String user;
    private String pass;
    private int maxMessages = 1;
    private int minSession = 1;
    private int maxSession = 15;
    private long keepAlive = 60000L;
    private boolean sessionTransacted = true;
    private String dLQHandler = "org.jboss.resource.adapter.jms.inflow.dlq.GenericDLQHandler";
    private boolean useDLQ = true;
    private String dLQJNDIName = "queue/DLQ";
    private String dLQUser;
    private String dLQPassword;
    private String dLQClientID;
    private int dLQMaxResent = 5;
    private int reconnectAttempts = 5;
    private boolean redeliverUnspecified = true;
    private int transactionTimeout;
    private Boolean isSameRMOverrideValue;
    private boolean forceClearOnShutdown = false;
    private long forceClearOnShutdownInterval = 1000L;
    private int forceClearAttempts = 0;

    public void setForceClearOnShutdown(boolean forceClear) {
        this.forceClearOnShutdown = forceClear;
    }

    public boolean isForceClearOnShutdown() {
        return this.forceClearOnShutdown;
    }

    public long getForceClearOnShutdownInterval() {
        return this.forceClearOnShutdownInterval;
    }

    public void setForceClearOnShutdownInterval(long forceClearOnShutdownInterval) {
        this.forceClearOnShutdownInterval = forceClearOnShutdownInterval;
    }

    public int getForceClearAttempts() {
        return this.forceClearAttempts;
    }

    public void setForceClearAttempts(int forceClearAttempts) {
        this.forceClearAttempts = forceClearAttempts;
    }

    public String getAcknowledgeMode() {
        if (this.sessionTransacted) {
            return "Transacted";
        }
        if (3 == this.acknowledgeMode) {
            return "Dups-ok-acknowledge";
        }
        return "Auto-acknowledge";
    }

    public void setAcknowledgeMode(String acknowledgeMode) {
        if ("DUPS_OK_ACKNOWLEDGE".equals(acknowledgeMode) || "Dups-ok-acknowledge".equals(acknowledgeMode)) {
            this.acknowledgeMode = 3;
        } else if ("AUTO_ACKNOWLEDGE".equals(acknowledgeMode) || "Auto-acknowledge".equals(acknowledgeMode)) {
            this.acknowledgeMode = 1;
        } else if ("SESSION_TRANSACTED".equals(acknowledgeMode)) {
            this.acknowledgeMode = 0;
        } else {
            throw new IllegalArgumentException("Unsupported acknowledgement mode " + acknowledgeMode);
        }
    }

    public int getAcknowledgeModeInt() {
        if (this.sessionTransacted) {
            return 0;
        }
        return this.acknowledgeMode;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getDestinationType() {
        return this.destinationType;
    }

    public void setDestinationType(String destinationType) {
        this.destinationType = destinationType;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public void setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
    }

    public String getSubscriptionDurability() {
        if (this.subscriptionDurability) {
            return "Durable";
        }
        return "NonDurable";
    }

    public void setSubscriptionDurability(String subscriptionDurability) {
        this.subscriptionDurability = "Durable".equals(subscriptionDurability);
    }

    public boolean isDurable() {
        return this.subscriptionDurability;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public void setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    public long getReconnectInterval() {
        return this.reconnectInterval;
    }

    public void setReconnectInterval(long reconnectInterval) {
        this.reconnectInterval = reconnectInterval;
    }

    public long getReconnectIntervalLong() {
        return this.reconnectInterval * 1000L;
    }

    public String getProviderAdapterJNDI() {
        return this.providerAdapterJNDI;
    }

    public void setProviderAdapterJNDI(String providerAdapterJNDI) {
        this.providerAdapterJNDI = providerAdapterJNDI;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.pass;
    }

    public void setPassword(String pass) {
        this.pass = pass;
    }

    public int getMaxMessages() {
        return this.maxMessages;
    }

    public void setMaxMessages(int maxMessages) {
        this.maxMessages = maxMessages;
    }

    public int getMaxMessagesInt() {
        return this.maxMessages;
    }

    public int getMinSession() {
        return this.minSession;
    }

    public void setMinSession(int minSession) {
        this.minSession = minSession;
    }

    public int getMinSessionInt() {
        return this.minSession;
    }

    public int getMaxSession() {
        return this.maxSession;
    }

    public void setMaxSession(int maxSession) {
        this.maxSession = maxSession;
    }

    public int getMaxSessionInt() {
        return this.maxSession;
    }

    public long getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(long keepAlive) {
        this.keepAlive = keepAlive;
    }

    public long getKeepAliveLong() {
        return this.keepAlive;
    }

    public boolean getSessionTransacted() {
        return this.sessionTransacted;
    }

    public void setSessionTransacted(boolean sessionTransacted) {
        this.sessionTransacted = sessionTransacted;
    }

    public boolean isSessionTransacted() {
        return this.sessionTransacted;
    }

    public String getDLQHandler() {
        return this.dLQHandler;
    }

    public void setDLQHandler(String handler) {
        this.dLQHandler = handler;
    }

    public String getDLQJNDIName() {
        return this.dLQJNDIName;
    }

    public void setDLQJNDIName(String name) {
        this.dLQJNDIName = name;
    }

    public boolean getUseDLQ() {
        return this.useDLQ;
    }

    public void setUseDLQ(boolean useDLQ) {
        this.useDLQ = useDLQ;
    }

    public boolean isUseDLQ() {
        return this.useDLQ;
    }

    public String getDLQClientID() {
        return this.dLQClientID;
    }

    public void setDLQClientID(String clientID) {
        this.dLQClientID = clientID;
    }

    public String getDLQPassword() {
        return this.dLQPassword;
    }

    public void setDLQPassword(String password) {
        this.dLQPassword = password;
    }

    public String getDLQUser() {
        return this.dLQUser;
    }

    public void setDLQUser(String user) {
        this.dLQUser = user;
    }

    public int getDLQMaxResent() {
        return this.dLQMaxResent;
    }

    public void setDLQMaxResent(int maxResent) {
        this.dLQMaxResent = maxResent;
    }

    public ResourceAdapter getResourceAdapter() {
        return this.ra;
    }

    public void setResourceAdapter(ResourceAdapter ra) throws ResourceException {
        this.ra = ra;
    }

    public void validate() throws InvalidPropertyException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("validate " + this));
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Strings.defaultToString((Object)this)).append('(');
        buffer.append("ra=").append(this.ra);
        buffer.append(" destination=").append(this.destination);
        buffer.append(" destinationType=").append(this.destinationType);
        if (this.messageSelector != null) {
            buffer.append(" selector=").append(this.messageSelector);
        }
        buffer.append(" tx=").append(this.sessionTransacted);
        if (!this.sessionTransacted) {
            buffer.append(" ack=").append(this.getAcknowledgeMode());
        }
        buffer.append(" durable=").append(this.subscriptionDurability);
        if (this.clientId != null) {
            buffer.append(" clientID=").append(this.clientId);
        }
        if (this.subscriptionName != null) {
            buffer.append(" subscription=").append(this.subscriptionName);
        }
        buffer.append(" reconnect=").append(this.reconnectInterval);
        buffer.append(" provider=").append(this.providerAdapterJNDI);
        buffer.append(" user=").append(this.user);
        if (this.pass != null) {
            buffer.append(" pass=").append("<not shown>");
        }
        buffer.append(" maxMessages=").append(this.maxMessages);
        buffer.append(" minSession=").append(this.minSession);
        buffer.append(" maxSession=").append(this.maxSession);
        buffer.append(" keepAlive=").append(this.keepAlive);
        buffer.append(" useDLQ=").append(this.useDLQ);
        if (this.useDLQ) {
            buffer.append(" DLQHandler=").append(this.dLQHandler);
            buffer.append(" DLQJndiName=").append(this.dLQJNDIName);
            buffer.append(" DLQUser=").append(this.dLQUser);
            if (this.dLQPassword != null) {
                buffer.append(" DLQPass=").append("<not shown>");
            }
            if (this.dLQClientID != null) {
                buffer.append(" DLQClientID=").append(this.dLQClientID);
            }
            buffer.append(" DLQMaxResent=").append(this.dLQMaxResent);
        }
        buffer.append(')');
        return buffer.toString();
    }

    public int getReconnectAttempts() {
        return this.reconnectAttempts;
    }

    public void setReconnectAttempts(int reconnectAttempts) {
        this.reconnectAttempts = reconnectAttempts;
    }

    public boolean getRedeliverUnspecified() {
        return this.redeliverUnspecified;
    }

    public void setRedeliverUnspecified(boolean redeliverUnspecified) {
        this.redeliverUnspecified = redeliverUnspecified;
    }

    public int getTransactionTimeout() {
        return this.transactionTimeout;
    }

    public void setTransactionTimeout(int transactionTimeout) {
        this.transactionTimeout = transactionTimeout;
    }

    public Boolean getIsSameRMOverrideValue() {
        return this.isSameRMOverrideValue;
    }

    public void setIsSameRMOverrideValue(Boolean isSameRMOverrideValue) {
        this.isSameRMOverrideValue = isSameRMOverrideValue;
    }
}

