/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import java.lang.management.ManagementFactory;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.platform.mbean.AbstractPlatformMBeanAttributeHandler;
import org.jboss.as.platform.mbean.PlatformMBeanConstants;
import org.jboss.as.platform.mbean.PlatformMBeanUtil;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ClassLoadingMXBeanAttributeHandler
extends AbstractPlatformMBeanAttributeHandler {
    public static ClassLoadingMXBeanAttributeHandler INSTANCE = new ClassLoadingMXBeanAttributeHandler();

    private ClassLoadingMXBeanAttributeHandler() {
        this.writeAttributeValidator.registerValidator("value", (ParameterValidator)new ModelTypeValidator(ModelType.BOOLEAN));
    }

    @Override
    protected void executeReadAttribute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String name = operation.require("name").asString();
        if (PlatformMBeanUtil.JVM_MAJOR_VERSION > 6 && "object-name".equals(name)) {
            context.getResult().set("java.lang:type=ClassLoading");
        } else if ("total-loaded-class-count".equals(name)) {
            context.getResult().set(ManagementFactory.getClassLoadingMXBean().getTotalLoadedClassCount());
        } else if ("loaded-class-count".equals(name)) {
            context.getResult().set(ManagementFactory.getClassLoadingMXBean().getLoadedClassCount());
        } else if ("unloaded-class-count".equals(name)) {
            context.getResult().set(ManagementFactory.getClassLoadingMXBean().getUnloadedClassCount());
        } else if ("verbose".equals(name)) {
            context.getResult().set(ManagementFactory.getClassLoadingMXBean().isVerbose());
        } else {
            if (PlatformMBeanConstants.CLASSLOADING_METRICS.contains(name) || PlatformMBeanConstants.CLASSLOADING_READ_WRITE_ATTRIBUTES.contains(name)) {
                throw new IllegalStateException(String.format("Read support for attribute %s was not properly implemented", name));
            }
            throw ClassLoadingMXBeanAttributeHandler.unknownAttribute(operation);
        }
    }

    @Override
    protected void executeWriteAttribute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String name = operation.require("name").asString();
        if (!"verbose".equals(name)) {
            if (PlatformMBeanConstants.CLASSLOADING_READ_WRITE_ATTRIBUTES.contains(name)) {
                throw new IllegalStateException(String.format("Write support for attribute %s was not properly implemented", name));
            }
            throw ClassLoadingMXBeanAttributeHandler.unknownAttribute(operation);
        }
        ManagementFactory.getClassLoadingMXBean().setVerbose(operation.require("value").asBoolean());
    }

    @Override
    protected void register(ManagementResourceRegistration registration) {
        if (PlatformMBeanUtil.JVM_MAJOR_VERSION > 6) {
            registration.registerReadOnlyAttribute("object-name", (OperationStepHandler)this, AttributeAccess.Storage.RUNTIME);
        }
        for (String attribute : PlatformMBeanConstants.CLASSLOADING_METRICS) {
            registration.registerMetric(attribute, (OperationStepHandler)this);
        }
        for (String attribute : PlatformMBeanConstants.CLASSLOADING_READ_WRITE_ATTRIBUTES) {
            registration.registerReadWriteAttribute(attribute, (OperationStepHandler)this, (OperationStepHandler)this, AttributeAccess.Storage.RUNTIME);
        }
    }
}

