/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.messagecounter.impl;

import java.text.DateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.StringTokenizer;
import org.hornetq.api.core.management.DayCounterInfo;
import org.hornetq.core.messagecounter.MessageCounter;

public class MessageCounterHelper {
    public static String listMessageCounterHistory(MessageCounter counter) throws Exception {
        List<MessageCounter.DayCounter> history = counter.getHistory();
        DayCounterInfo[] infos = new DayCounterInfo[history.size()];
        for (int i = 0; i < infos.length; ++i) {
            MessageCounter.DayCounter dayCounter = history.get(i);
            int[] counters = dayCounter.getCounters();
            GregorianCalendar date = dayCounter.getDate();
            DateFormat dateFormat = DateFormat.getDateInstance(3);
            String strData = dateFormat.format(date.getTime());
            infos[i] = new DayCounterInfo(strData, counters);
        }
        return DayCounterInfo.toJSON(infos);
    }

    public static String listMessageCounterAsHTML(MessageCounter[] counters) {
        if (counters == null) {
            return null;
        }
        String ret = "<table class=\"hornetq-message-counter\">\n<tr><th>Type</th><th>Name</th><th>Subscription</th><th>Durable</th><th>Count</th><th>CountDelta</th><th>Depth</th><th>DepthDelta</th><th>Last Add</th><th>Last Update</th></tr>\n";
        for (int i = 0; i < counters.length; ++i) {
            MessageCounter counter = counters[i];
            String type = counter.isDestinationTopic() ? "Topic" : "Queue";
            String subscription = counter.getDestinationSubscription();
            if (subscription == null) {
                subscription = "-";
            }
            String durableStr = "-";
            if (counter.isDestinationTopic()) {
                durableStr = Boolean.toString(counter.isDestinationDurable());
            }
            ret = ret + "<tr bgcolor=\"#" + (i % 2 == 0 ? "FFFFFF" : "F0F0F0") + "\">";
            ret = ret + "<td>" + type + "</td>";
            ret = ret + "<td>" + counter.getDestinationName() + "</td>";
            ret = ret + "<td>" + subscription + "</td>";
            ret = ret + "<td>" + durableStr + "</td>";
            ret = ret + "<td>" + counter.getCount() + "</td>";
            ret = ret + "<td>" + MessageCounterHelper.prettify(counter.getCountDelta()) + "</td>";
            ret = ret + "<td>" + MessageCounterHelper.prettify(counter.getMessageCount()) + "</td>";
            ret = ret + "<td>" + MessageCounterHelper.prettify(counter.getMessageCountDelta()) + "</td>";
            ret = ret + "<td>" + MessageCounterHelper.asDate(counter.getLastAddedMessageTime()) + "</td>";
            ret = ret + "<td>" + MessageCounterHelper.asDate(counter.getLastUpdate()) + "</td>";
            ret = ret + "</tr>\n";
        }
        ret = ret + "</table>\n";
        return ret;
    }

    public static String listMessageCounterHistoryAsHTML(MessageCounter[] counters) {
        if (counters == null) {
            return null;
        }
        String ret = "<ul>\n";
        for (MessageCounter counter : counters) {
            ret = ret + "<li>\n";
            ret = ret + "  <ul>\n";
            ret = ret + "    <li>";
            ret = ret + (counter.isDestinationTopic() ? "Topic '" : "Queue '") + counter.getDestinationName() + "'";
            ret = ret + "</li>\n";
            if (counter.getDestinationSubscription() != null) {
                ret = ret + "    <li>";
                ret = ret + "Subscription '" + counter.getDestinationSubscription() + "'";
                ret = ret + "</li>\n";
            }
            ret = ret + "    <li>";
            ret = ret + "<table class=\"hornetq-message-counter-history\">\n";
            ret = ret + "<tr><th>Date</th>";
            for (int j = 0; j < 24; ++j) {
                ret = ret + "<th>" + j + "</th>";
            }
            ret = ret + "<th>Total</th></tr>\n";
            StringTokenizer tokens = new StringTokenizer(counter.getHistoryAsString(), ",\n");
            int days = Integer.parseInt(tokens.nextToken());
            for (int j = 0; j < days; ++j) {
                ret = ret + "<tr bgcolor=\"#" + (j % 2 == 0 ? "FFFFFF" : "F0F0F0") + "\">";
                ret = ret + "<td>" + tokens.nextToken() + "</td>";
                int total = 0;
                for (int k = 0; k < 24; ++k) {
                    int value = Integer.parseInt(tokens.nextToken().trim());
                    if (value == -1) {
                        ret = ret + "<td></td>";
                        continue;
                    }
                    ret = ret + "<td>" + value + "</td>";
                    total += value;
                }
                ret = ret + "<td>" + total + "</td></tr>\n";
            }
            ret = ret + "</table></li>\n";
            ret = ret + "  </ul>\n";
            ret = ret + "</li>\n";
        }
        ret = ret + "</ul>\n";
        return ret;
    }

    private static String prettify(long value) {
        if (value == 0L) {
            return "-";
        }
        return Long.toString(value);
    }

    private static String asDate(long time) {
        if (time > 0L) {
            return DateFormat.getDateTimeInstance(3, 2).format(new Date(time));
        }
        return "-";
    }
}

