/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxr.extension;

import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.jaxr.JAXRConfiguration;
import org.jboss.as.jaxr.extension.JAXRPropertyWrite;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;

public class JAXRPropertyAdd
extends AbstractAddStepHandler {
    private final JAXRConfiguration config;
    static DescriptionProvider DESCRIPTION = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ModelNode node = new ModelNode();
            ResourceBundle resbundle = JAXRConfiguration.getResourceBundle(locale);
            node.get("operation-name").set("add");
            node.get("description").set(resbundle.getString("jaxr.property.add"));
            node.get(new String[]{"request-properties", "value", "description"}).set(resbundle.getString("jaxr.property.value"));
            node.get(new String[]{"request-properties", "value", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "value", "required"}).set(true);
            return node;
        }
    };

    public JAXRPropertyAdd(JAXRConfiguration config) {
        this.config = config;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        JAXRPropertyWrite.VALUE.validateAndSet(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        String propertyName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        this.config.applyUpdateToConfig(propertyName, JAXRPropertyWrite.VALUE.resolveModelAttribute(context, model).asString());
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, ModelNode model, List<ServiceController<?>> controllers) {
        String propertyName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        this.config.applyUpdateToConfig(propertyName, null);
    }
}

