/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.iiop;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.TaggedComponentList;
import org.jacorb.orb.etf.ProfileBase;
import org.jacorb.orb.etf.ProtocolAddressBase;
import org.jacorb.orb.iiop.IIOPAddress;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.CSIIOP.CompoundSecMechListHelper;
import org.omg.CSIIOP.TLS_SEC_TRANS;
import org.omg.CSIIOP.TLS_SEC_TRANSHelper;
import org.omg.ETF.Profile;
import org.omg.GIOP.Version;
import org.omg.GIOP.VersionHelper;
import org.omg.IOP.TaggedComponent;
import org.omg.SSLIOP.SSL;
import org.omg.SSLIOP.SSLHelper;
import org.slf4j.Logger;

public class IIOPProfile
extends ProfileBase
implements Cloneable {
    private IIOPAddress primaryAddress = null;
    private Logger logger;
    private static final int MINIMUM_OPTIONS = 126;

    public IIOPProfile() {
    }

    public IIOPProfile(byte[] byArray) {
        this();
        this.initFromProfileData(byArray);
    }

    public IIOPProfile(IIOPAddress iIOPAddress, byte[] byArray, int n) {
        this();
        this.version = new Version(1, (byte)n);
        this.primaryAddress = iIOPAddress;
        this.objectKey = byArray;
        this.components = new TaggedComponentList();
    }

    public IIOPProfile(IIOPAddress iIOPAddress, byte[] byArray) {
        this(iIOPAddress, byArray, 2);
    }

    public IIOPProfile(String string) {
        this();
        this.version = null;
        this.primaryAddress = null;
        this.objectKey = null;
        this.components = null;
        this.corbalocStr = string;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = configuration;
        this.logger = this.configuration.getLogger("jacorb.iiop.profile");
        if (this.primaryAddress != null) {
            this.primaryAddress.configure(configuration);
        }
        if (this.corbalocStr != null) {
            try {
                this.decode_corbaloc(this.corbalocStr);
            }
            catch (Exception exception) {
                this.logger.debug("unable to decode_corbaloc", (Throwable)exception);
            }
        }
        this.addAlternateAddresses(configuration);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void decode_corbaloc(String string) {
        String string2 = string;
        String string3 = "127.0.0.1";
        int n = 2809;
        int n2 = 1;
        int n3 = 0;
        String string4 = "Illegal IIOP protocol format in object address format: " + string2;
        int n4 = string2.indexOf(58);
        String string5 = "";
        if (n4 != 0) {
            string5 = string2.substring(0, n4);
        }
        if (n4 + 1 == string2.length()) {
            throw new IllegalArgumentException(string4);
        }
        if ((n4 = (string2 = string2.substring(n4 + 1)).indexOf(64)) > -1) {
            String string6 = string2.substring(0, n4);
            string2 = string2.substring(n4 + 1);
            n4 = string6.indexOf(46);
            if (n4 != -1) {
                try {
                    n2 = Integer.parseInt(string6.substring(0, n4));
                    n3 = Integer.parseInt(string6.substring(n4 + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(string4);
                }
            }
        }
        this.version = new Version((byte)n2, (byte)n3);
        int n5 = -1;
        int n6 = -1;
        n5 = string2.indexOf(91);
        if (n5 != -1 && (n6 = string2.indexOf(93)) == -1) {
            throw new IllegalArgumentException(string4);
        }
        n4 = string2.indexOf(58);
        if (n4 != -1) {
            if (n5 != -1) {
                string3 = string2.substring(n5 + 1, n6);
                if (string2.charAt(n6 + 1) != ':') throw new IllegalArgumentException(string4);
                n = (short)Integer.parseInt(string2.substring(n6 + 2));
            } else {
                try {
                    n = (short)Integer.parseInt(string2.substring(n4 + 1));
                    string3 = string2.substring(0, n4);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(string4);
                }
            }
        }
        this.primaryAddress = new IIOPAddress(string3, n);
        try {
            this.primaryAddress.configure(this.configuration);
        }
        catch (ConfigurationException configurationException) {
            this.logger.warn("ConfigurationException", (Throwable)configurationException);
        }
        this.decode_extensions(string5.toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decode_extensions(String string) {
        this.components = new TaggedComponentList();
        if (string.equals("ssliop")) {
            SSL sSL = new SSL();
            sSL.port = (short)this.primaryAddress.getPort();
            String string2 = "jacorb.security.ssl.corbaloc_ssliop.supported_options";
            sSL.target_supports = this.get_ssl_options(string2);
            string2 = "jacorb.security.ssl.corbaloc_ssliop.required_options";
            sSL.target_requires = this.get_ssl_options(string2);
            CDROutputStream cDROutputStream = new CDROutputStream();
            try {
                cDROutputStream.beginEncapsulatedArray();
                SSLHelper.write(cDROutputStream, sSL);
                this.components.addComponent(new TaggedComponent(20, cDROutputStream.getBufferCopy()));
            }
            finally {
                cDROutputStream.close();
            }
        }
    }

    private short get_ssl_options(String string) {
        short s = (short)this.configuration.getAttributeAsInteger(string, 32);
        return s;
    }

    private void addAlternateAddresses(Configuration configuration) {
        String string = configuration.getAttribute("jacorb.iiop.alternate_addresses", null);
        if (string == null) {
            return;
        }
        if (string.trim().equals("auto")) {
            this.addNetworkAddresses();
        } else {
            List<String> list = Arrays.asList(string.split(","));
            if (!list.isEmpty() && this.components == null) {
                this.components = new TaggedComponentList();
            }
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                IIOPAddress iIOPAddress = new IIOPAddress();
                String string2 = iterator.next();
                if (!iIOPAddress.fromString(string2)) {
                    this.logger.warn("could not decode " + string2 + " from jacorb.iiop.alternate_addresses");
                    continue;
                }
                this.components.addComponent(3, iIOPAddress.toCDR());
            }
        }
    }

    private void addNetworkAddresses() {
        if (this.primaryAddress == null) {
            return;
        }
        if (this.components == null) {
            this.components = new TaggedComponentList();
        }
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (!(inetAddress instanceof Inet4Address) || inetAddress.isLoopbackAddress() || inetAddress.getHostAddress().equals(this.primaryAddress.getIP())) continue;
                    IIOPAddress iIOPAddress = new IIOPAddress();
                    iIOPAddress.fromString(inetAddress.toString().substring(1) + ":" + this.primaryAddress.getPort());
                    this.components.addComponent(3, iIOPAddress.toCDR());
                }
            }
        }
        catch (SocketException socketException) {
            this.logger.warn("could not get network interfaces, will not add addresses");
        }
    }

    public void writeAddressProfile(CDROutputStream cDROutputStream) {
        VersionHelper.write(cDROutputStream, this.version);
        this.primaryAddress.write(cDROutputStream);
    }

    public void readAddressProfile(CDRInputStream cDRInputStream) {
        this.version = VersionHelper.read(cDRInputStream);
        this.primaryAddress = IIOPAddress.read(cDRInputStream);
        if (this.configuration != null) {
            try {
                this.primaryAddress.configure(this.configuration);
            }
            catch (ConfigurationException configurationException) {
                this.logger.warn("ConfigurationException", (Throwable)configurationException);
            }
        }
    }

    public int hash() {
        return this.hashCode();
    }

    public Object clone() throws CloneNotSupportedException {
        IIOPProfile iIOPProfile = (IIOPProfile)super.clone();
        iIOPProfile.primaryAddress = new IIOPAddress(this.primaryAddress.getHostname(), this.primaryAddress.getPort());
        if (this.configuration != null) {
            try {
                iIOPProfile.primaryAddress.configure(this.configuration);
            }
            catch (ConfigurationException configurationException) {
                this.logger.warn("ConfigurationException", (Throwable)configurationException);
            }
        }
        iIOPProfile.version = new Version(this.version.major, this.version.minor);
        if (this.objectKey != null) {
            iIOPProfile.objectKey = new byte[this.objectKey.length];
            System.arraycopy(this.objectKey, 0, iIOPProfile.objectKey, 0, this.objectKey.length);
        }
        if (this.components != null) {
            iIOPProfile.components = (TaggedComponentList)this.components.clone();
        }
        return iIOPProfile;
    }

    public boolean is_match(Profile profile) {
        if (profile == null) {
            return false;
        }
        if (profile instanceof IIOPProfile) {
            IIOPProfile iIOPProfile = (IIOPProfile)profile;
            return this.getSSLPort() == iIOPProfile.getSSLPort() && this.primaryAddress.equals(iIOPProfile.primaryAddress) && ((Object)this.getAlternateAddresses()).equals(iIOPProfile.getAlternateAddresses());
        }
        return false;
    }

    public int tag() {
        return 0;
    }

    public ProtocolAddressBase getAddress() {
        return this.primaryAddress;
    }

    public void patchPrimaryAddress(ProtocolAddressBase protocolAddressBase) {
        if (protocolAddressBase instanceof IIOPAddress) {
            this.primaryAddress.replaceFrom((IIOPAddress)protocolAddressBase);
        }
    }

    public List getAlternateAddresses() {
        return this.components.getComponents(3, IIOPAddress.class);
    }

    public SSL getSSL() {
        return (SSL)this.components.getComponent(20, SSLHelper.class);
    }

    public int getSSLPort() {
        TLS_SEC_TRANS tLS_SEC_TRANS = this.getTlsSpecFromCSIComponent();
        if (tLS_SEC_TRANS != null && tLS_SEC_TRANS.addresses.length > 0) {
            return IIOPProfile.adjustedPortNum(tLS_SEC_TRANS.addresses[0].port);
        }
        SSL sSL = this.getSSL();
        if (sSL != null) {
            return IIOPProfile.adjustedPortNum(sSL.port);
        }
        return -1;
    }

    public IIOPProfile to_GIOP_1_0() {
        IIOPProfile iIOPProfile = new IIOPProfile(this.primaryAddress, this.objectKey);
        iIOPProfile.version.minor = 0;
        return iIOPProfile;
    }

    public boolean equals(Object object) {
        return object instanceof Profile && this.is_match((Profile)object);
    }

    public int hashCode() {
        return this.primaryAddress.hashCode();
    }

    public String toString() {
        return this.primaryAddress.toString();
    }

    int getSslPortIfSupported(int n, int n2) {
        TLS_SEC_TRANS tLS_SEC_TRANS = this.getTlsSpecFromCSIComponent();
        SSL sSL = (SSL)this.getComponent(20, SSLHelper.class);
        if (tLS_SEC_TRANS != null && this.useSsl(n2, n, tLS_SEC_TRANS.target_supports, tLS_SEC_TRANS.target_requires)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Selecting TLS for connection");
            }
            return IIOPProfile.adjustedPortNum(tLS_SEC_TRANS.addresses[0].port);
        }
        if (sSL != null && this.useSsl(n2, n, sSL.target_supports, sSL.target_requires)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Selecting SSL for connection");
            }
            return IIOPProfile.adjustedPortNum(sSL.port);
        }
        if ((n & 0x7E) != 0) {
            throw new NO_PERMISSION("Client-side policy requires SSL/TLS, but server doesn't support it");
        }
        return -1;
    }

    private static int adjustedPortNum(short n) {
        return n < 0 ? n + 65536 : n;
    }

    private boolean useSsl(int n, int n2, short s, short s2) {
        return (s & 0x7E) != 0 && (n & 0x7E) != 0 && ((s2 & 0x7E) != 0 || (n2 & 0x7E) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TLS_SEC_TRANS getTlsSpecFromCSIComponent() {
        CompoundSecMechList compoundSecMechList = null;
        try {
            compoundSecMechList = (CompoundSecMechList)this.getComponent(33, CompoundSecMechListHelper.class);
        }
        catch (Exception exception) {
            this.logger.info("Not able to process security mech. component");
        }
        TLS_SEC_TRANS tLS_SEC_TRANS = null;
        if (compoundSecMechList != null && compoundSecMechList.mechanism_list[0].transport_mech.tag == 36) {
            try {
                byte[] byArray = compoundSecMechList.mechanism_list[0].transport_mech.component_data;
                CDRInputStream cDRInputStream = new CDRInputStream(null, byArray);
                try {
                    cDRInputStream.openEncapsulatedArray();
                    tLS_SEC_TRANS = TLS_SEC_TRANSHelper.read(cDRInputStream);
                }
                finally {
                    cDRInputStream.close();
                }
            }
            catch (Exception exception) {
                this.logger.warn("Error parsing TLS_SEC_TRANS: " + exception);
            }
        }
        return tLS_SEC_TRANS;
    }
}

