/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.Locale;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.SocketBindingGroupDescription;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class SocketBindingGroupIncludeRemoveHandler
extends AbstractRemoveStepHandler
implements DescriptionProvider {
    public static final String OPERATION_NAME = "remove-included-group";
    public static final SocketBindingGroupIncludeRemoveHandler INSTANCE = new SocketBindingGroupIncludeRemoveHandler();
    private final ParameterValidator typeValidator = new ModelTypeValidator(ModelType.STRING);

    public static ModelNode getOperation(ModelNode address, String group) {
        ModelNode op = new ModelNode();
        op.get("operation").set(OPERATION_NAME);
        op.get("address").set(address);
        op.get("include").set(group);
        return op;
    }

    private SocketBindingGroupIncludeRemoveHandler() {
    }

    @Override
    protected void performRemove(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ModelNode param = operation.get("include");
        ModelNode includes = model.get("include");
        ModelNode toRemove = null;
        this.typeValidator.validateParameter("include", param);
        ModelNode newList = new ModelNode().setEmptyList();
        String group = param.asString();
        if (includes.isDefined()) {
            for (ModelNode included : includes.asList()) {
                if (group.equals(included.asString())) continue;
                toRemove = newList.add(included);
                break;
            }
        }
        if (toRemove == null) {
            throw new OperationFailedException(new ModelNode().set(ControllerMessages.MESSAGES.groupNotFound(group)));
        }
        includes.set(newList);
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        return SocketBindingGroupDescription.getRemoveSocketBindingGroupIncludeOperation(locale);
    }
}

