/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.test.impl;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;
import org.jboss.arquillian.config.descriptor.api.Multiline;
import org.jboss.arquillian.container.test.impl.MultilineTrimmer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapObject {
    public static Logger log = Logger.getLogger(MapObject.class.getName());

    public static void populate(Object object, Map<String, String> values) throws Exception {
        HashMap<String, String> clonedValues = new HashMap<String, String>(values);
        HashSet<String> candidates = new HashSet<String>();
        Class<?> clazz = object.getClass();
        for (Method candidate : clazz.getMethods()) {
            if (!MapObject.isSetter(candidate)) continue;
            candidate.setAccessible(true);
            String methodName = candidate.getName();
            String propertyName = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
            candidates.add(propertyName);
            if (!clonedValues.containsKey(propertyName)) continue;
            if (MapObject.shouldBeTrimmed(candidate)) {
                String trimmed = MultilineTrimmer.trim((String)clonedValues.get(propertyName));
                clonedValues.put(propertyName, trimmed);
            }
            candidate.invoke(object, MapObject.convert(candidate.getParameterTypes()[0], (String)clonedValues.get(propertyName)));
            clonedValues.remove(propertyName);
        }
        if (!clonedValues.isEmpty()) {
            log.warning("Configuration contain properties not supported by the backing object " + clazz.getName() + "\n" + "Unused property entries: " + clonedValues + "\n" + "Supported property names: " + candidates);
        }
    }

    public static URL[] convert(File[] files) {
        URL[] urls = new URL[files.length];
        try {
            for (int i = 0; i < files.length; ++i) {
                urls[i] = files[i].toURI().toURL();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create URL from a File object?", e);
        }
        return urls;
    }

    private static boolean isSetter(Method candidate) {
        return candidate.getName().matches("^set[A-Z].*") && candidate.getReturnType().equals(Void.TYPE) && candidate.getParameterTypes().length == 1;
    }

    private static boolean shouldBeTrimmed(Method candidate) {
        return String.class.equals(candidate.getParameterTypes()[0]) && !candidate.isAnnotationPresent(Multiline.class);
    }

    private static Object convert(Class<?> clazz, String value) {
        if (Integer.class.equals(clazz) || Integer.TYPE.equals(clazz)) {
            return Integer.valueOf(value);
        }
        if (Double.class.equals(clazz) || Double.TYPE.equals(clazz)) {
            return Double.valueOf(value);
        }
        if (Long.class.equals(clazz) || Long.TYPE.equals(clazz)) {
            return Long.valueOf(value);
        }
        if (Boolean.class.equals(clazz) || Boolean.TYPE.equals(clazz)) {
            return Boolean.valueOf(value);
        }
        return value;
    }
}

