/*
 * JBoss, Home of Professional Open Source
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.arquillian.container.test.api;

import java.io.InputStream;

/**
 * A interface that describes how you can deploy a named Deployment during test execution.
 *
 * @author <a href="mailto:aslak@redhat.com">Aslak Knutsen</a>
 * @version $Revision: $
 */
public interface Deployer
{
   /**
    * Deploy a named deployment.
    * 
    * @param name The name of the deployment
    */
   public void deploy(String name);
   
   /**
    * Get the Deployment content.
    * 
    * @param name The name of the Deployment as defined by Deployment
    * @return a Zipped Stream of the Archive
    */
   public InputStream getDeployment(String name);
   
   /**
    * UnDeploy a named deployment.
    * 
    * @param name The name of the deployment
    */
   public void undeploy(String name);
}
