/*
 * Decompiled with CFR 0.152.
 */
package org.javers.spring.boot.sql;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.javers.core.Javers;
import org.javers.core.JaversBuilder;
import org.javers.core.JaversBuilderPlugin;
import org.javers.core.JaversCoreProperties;
import org.javers.repository.api.JaversRepository;
import org.javers.repository.sql.ConnectionProvider;
import org.javers.repository.sql.DialectName;
import org.javers.repository.sql.JaversSqlRepository;
import org.javers.repository.sql.SqlRepositoryBuilder;
import org.javers.spring.RegisterJsonTypeAdaptersPlugin;
import org.javers.spring.aot.JaversSpringNativeHints;
import org.javers.spring.auditable.AuthorProvider;
import org.javers.spring.auditable.CommitPropertiesProvider;
import org.javers.spring.auditable.EmptyPropertiesProvider;
import org.javers.spring.auditable.MockAuthorProvider;
import org.javers.spring.auditable.SpringSecurityAuthorProvider;
import org.javers.spring.auditable.aspect.JaversAuditableAspect;
import org.javers.spring.auditable.aspect.springdatajpa.JaversSpringDataJpaAuditableRepositoryAspect;
import org.javers.spring.boot.aot.JaversSqlNativeHints;
import org.javers.spring.boot.sql.DialectMapper;
import org.javers.spring.boot.sql.JaversSqlProperties;
import org.javers.spring.jpa.JpaHibernateConnectionProvider;
import org.javers.spring.jpa.TransactionalJpaJaversBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@EnableAspectJAutoProxy
@EnableConfigurationProperties(value={JaversSqlProperties.class, JpaProperties.class})
@AutoConfigureAfter(value={HibernateJpaAutoConfiguration.class})
@Import(value={RegisterJsonTypeAdaptersPlugin.class})
@ImportRuntimeHints(value={JaversSpringNativeHints.class, JaversSqlNativeHints.class})
public class JaversSqlAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(JaversSqlAutoConfiguration.class);
    private final DialectMapper dialectMapper = new DialectMapper();
    @Autowired
    private JaversSqlProperties javersSqlProperties;
    @Autowired(required=false)
    private List<JaversBuilderPlugin> plugins = new ArrayList<JaversBuilderPlugin>();
    @Autowired
    private EntityManagerFactory entityManagerFactory;

    @Bean
    public DialectName javersSqlDialectName() {
        SessionFactoryImplementor sessionFactory = (SessionFactoryImplementor)this.entityManagerFactory.unwrap(SessionFactoryImplementor.class);
        Dialect hibernateDialect = sessionFactory.getJdbcServices().getDialect();
        logger.info("detected Hibernate dialect: " + hibernateDialect.getClass().getSimpleName());
        return this.dialectMapper.map(hibernateDialect);
    }

    @Bean(name={"JaversSqlRepositoryFromStarter"})
    @ConditionalOnMissingBean
    public JaversSqlRepository javersSqlRepository(ConnectionProvider connectionProvider) {
        return SqlRepositoryBuilder.sqlRepository().withSchema(this.javersSqlProperties.getSqlSchema()).withConnectionProvider(connectionProvider).withDialect(this.javersSqlDialectName()).withSchemaManagementEnabled(this.javersSqlProperties.isSqlSchemaManagementEnabled()).withGlobalIdCacheDisabled(this.javersSqlProperties.isSqlGlobalIdCacheDisabled()).withGlobalIdTableName(this.javersSqlProperties.getSqlGlobalIdTableName()).withCommitTableName(this.javersSqlProperties.getSqlCommitTableName()).withSnapshotTableName(this.javersSqlProperties.getSqlSnapshotTableName()).withCommitPropertyTableName(this.javersSqlProperties.getSqlCommitPropertyTableName()).build();
    }

    @Bean(name={"JaversFromStarter"})
    @ConditionalOnMissingBean
    public Javers javers(JaversSqlRepository sqlRepository, PlatformTransactionManager transactionManager) {
        JaversBuilder javersBuilder = TransactionalJpaJaversBuilder.javers().withTxManager(transactionManager).registerJaversRepository((JaversRepository)sqlRepository).withObjectAccessHook(this.javersSqlProperties.createObjectAccessHookInstance()).withProperties((JaversCoreProperties)this.javersSqlProperties);
        this.plugins.forEach(plugin -> plugin.beforeAssemble(javersBuilder));
        return javersBuilder.build();
    }

    @Bean(name={"SpringSecurityAuthorProvider"})
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"org.springframework.security.core.context.SecurityContextHolder"})
    public AuthorProvider springSecurityAuthorProvider() {
        return new SpringSecurityAuthorProvider();
    }

    @Bean(name={"MockAuthorProvider"})
    @ConditionalOnMissingBean
    @ConditionalOnMissingClass(value={"org.springframework.security.core.context.SecurityContextHolder"})
    public AuthorProvider unknownAuthorProvider() {
        return new MockAuthorProvider();
    }

    @Bean(name={"EmptyPropertiesProvider"})
    @ConditionalOnMissingBean
    public CommitPropertiesProvider commitPropertiesProvider() {
        return new EmptyPropertiesProvider();
    }

    @Bean(name={"JpaHibernateConnectionProvider"})
    @ConditionalOnMissingBean
    public ConnectionProvider jpaConnectionProvider(EntityManager entityManager) {
        return new JpaHibernateConnectionProvider(entityManager);
    }

    @Bean
    @ConditionalOnProperty(name={"javers.auditableAspectEnabled"}, havingValue="true", matchIfMissing=true)
    public JaversAuditableAspect javersAuditableAspect(Javers javers, AuthorProvider authorProvider, CommitPropertiesProvider commitPropertiesProvider) {
        return new JaversAuditableAspect(javers, authorProvider, commitPropertiesProvider);
    }

    @Bean
    @ConditionalOnProperty(name={"javers.springDataAuditableRepositoryAspectEnabled"}, havingValue="true", matchIfMissing=true)
    public JaversSpringDataJpaAuditableRepositoryAspect javersSpringDataAuditableAspect(Javers javers, AuthorProvider authorProvider, CommitPropertiesProvider commitPropertiesProvider) {
        return new JaversSpringDataJpaAuditableRepositoryAspect(javers, authorProvider, commitPropertiesProvider);
    }
}

