/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.portlets.bookmarks.dao.template;

import edu.wisc.my.portlets.bookmarks.dao.BookmarkStore;
import edu.wisc.my.portlets.bookmarks.dao.template.TemplateBookmarkSetResolver;
import edu.wisc.my.portlets.bookmarks.domain.BookmarkSet;
import edu.wisc.my.portlets.bookmarks.domain.Entry;
import edu.wisc.my.portlets.bookmarks.domain.support.FolderUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TemplateUserBookmarkStore
implements BookmarkStore {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final BookmarkStore enclosed;
    private final TemplateBookmarkSetResolver resolver;

    public TemplateUserBookmarkStore(BookmarkStore enclosed, TemplateBookmarkSetResolver resolver) {
        if (enclosed == null) {
            String msg = "Argument 'enclosed' cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        if (resolver == null) {
            String msg = "Argument 'resolver' cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        this.enclosed = enclosed;
        this.resolver = resolver;
    }

    public BookmarkSet getBookmarkSet(String owner, String name) {
        BookmarkSet rslt = this.enclosed.getBookmarkSet(owner, name);
        BookmarkSet template = this.resolver.getTemplateBookmarkSet(owner, name, this.enclosed);
        if (rslt == null && template != null && template.getChildren().size() > 0) {
            rslt = this.createBookmarkSet(owner, name);
        }
        return rslt;
    }

    public void storeBookmarkSet(BookmarkSet bookmarkSet) {
        this.enclosed.storeBookmarkSet(bookmarkSet);
    }

    public void removeBookmarkSet(String owner, String name) {
        this.enclosed.removeBookmarkSet(owner, name);
    }

    public BookmarkSet createBookmarkSet(String owner, String name) {
        BookmarkSet rslt = this.enclosed.createBookmarkSet(owner, name);
        BookmarkSet template = this.resolver.getTemplateBookmarkSet(owner, name, this.enclosed);
        if (template != null && template.getChildren().size() > 0) {
            for (Entry y : template.getChildren().values()) {
                Entry newEntry = FolderUtils.deepClone((Entry)y, (boolean)false);
                rslt.getChildren().put(Long.valueOf(newEntry.hashCode()), newEntry);
            }
            this.logger.info((Object)("TemplateUserBookmarkStore created a new BookmarkSet for user '" + owner + "' with " + rslt.getChildren().size() + " bookmarks."));
        }
        this.enclosed.storeBookmarkSet(rslt);
        return rslt;
    }
}

