/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.plugin.deployer.config;

import java.io.File;
import java.io.IOException;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.jasig.portal.plugin.deployer.AbstractEarDeployer;
import org.jasig.portal.plugin.deployer.WebModule;
import org.jasig.portal.plugin.deployer.config.TomcatDeployerConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatEarDeployer
extends AbstractEarDeployer<TomcatDeployerConfig> {
    @Override
    protected final void deployWar(WebModule webModule, JarFile earFile, TomcatDeployerConfig tomcatDeployerConfig) throws IOException {
        File contextDir;
        String webUri = webModule.getWebUri();
        JarEntry warEntry = earFile.getJarEntry(webUri);
        File webappsDir = tomcatDeployerConfig.getWebAppsDir();
        String contextName = webModule.getContextRoot();
        if (contextName.endsWith(".war")) {
            contextName = contextName.substring(contextName.length() - 4);
        }
        if (contextName.startsWith("/")) {
            contextName = contextName.substring(1);
        }
        if (tomcatDeployerConfig.isRemoveExistingDirectories() && (contextDir = new File(webappsDir, contextName)).exists()) {
            FileUtils.deleteDirectory((File)contextDir);
        }
        if (tomcatDeployerConfig.isExtractWars()) {
            contextDir = new File(webappsDir, contextName);
            this.extractWar(earFile, warEntry, contextDir);
        } else {
            String warName = contextName = contextName + ".war";
            File warDest = this.createSafeFile(webappsDir, warName);
            this.copyAndClose(warEntry, earFile, warDest);
        }
    }

    @Override
    protected final void deployJar(JarEntry jarEntry, JarFile earFile, TomcatDeployerConfig tomcatDeployerConfig) throws IOException {
        String jarName = jarEntry.getName();
        if (jarName.contains("/")) {
            throw new IllegalArgumentException("The EAR contains a JAR entry in a folder, this is not supported. Bad Jar: '" + jarName + "'");
        }
        File sharedLibDir = tomcatDeployerConfig.getJarDir();
        File jarDest = this.createSafeFile(sharedLibDir, jarName);
        this.copyAndClose(jarEntry, earFile, jarDest);
    }
}

