/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.agent.rt_6l8m50.core.data;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.jacoco.agent.rt_6l8m50.core.data.ExecutionData;
import org.jacoco.agent.rt_6l8m50.core.data.IExecutionDataVisitor;
import org.jacoco.agent.rt_6l8m50.core.data.ISessionInfoVisitor;
import org.jacoco.agent.rt_6l8m50.core.data.SessionInfo;
import org.jacoco.agent.rt_6l8m50.core.internal.data.CompactDataInput;

public class ExecutionDataReader {
    protected final CompactDataInput in;
    private ISessionInfoVisitor sessionInfoVisitor = null;
    private IExecutionDataVisitor executionDataVisitor = null;
    private boolean firstBlock = true;

    public ExecutionDataReader(InputStream input) {
        this.in = new CompactDataInput(input);
    }

    public void setSessionInfoVisitor(ISessionInfoVisitor visitor) {
        this.sessionInfoVisitor = visitor;
    }

    public void setExecutionDataVisitor(IExecutionDataVisitor visitor) {
        this.executionDataVisitor = visitor;
    }

    public boolean read() throws IOException {
        try {
            byte type;
            do {
                type = this.in.readByte();
                if (this.firstBlock && type != 1) {
                    throw new IOException("Invalid execution data file.");
                }
                this.firstBlock = false;
            } while (this.readBlock(type));
            return true;
        }
        catch (EOFException e) {
            return false;
        }
    }

    protected boolean readBlock(byte blocktype) throws IOException {
        switch (blocktype) {
            case 1: {
                this.readHeader();
                return true;
            }
            case 16: {
                this.readSessionInfo();
                return true;
            }
            case 17: {
                this.readExecutionData();
                return true;
            }
        }
        throw new IOException(String.format("Unknown block type %x.", blocktype));
    }

    private void readHeader() throws IOException {
        if (this.in.readChar() != '\uc0c0') {
            throw new IOException("Invalid execution data file.");
        }
        char version = this.in.readChar();
        if (version != '\u1006') {
            throw new IOException(String.format("Incompatible version %x.", version));
        }
    }

    private void readSessionInfo() throws IOException {
        if (this.sessionInfoVisitor == null) {
            throw new IOException("No session info visitor.");
        }
        String id = this.in.readUTF();
        long start = this.in.readLong();
        long dump = this.in.readLong();
        this.sessionInfoVisitor.visitSessionInfo(new SessionInfo(id, start, dump));
    }

    private void readExecutionData() throws IOException {
        if (this.executionDataVisitor == null) {
            throw new IOException("No execution data visitor.");
        }
        long id = this.in.readLong();
        String name = this.in.readUTF();
        boolean[] data = this.in.readBooleanArray();
        this.executionDataVisitor.visitClassExecution(new ExecutionData(id, name, data));
    }
}

