/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.agent.rt_jzhc14;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import org.jacoco.agent.rt_jzhc14.IExceptionLogger;
import org.jacoco.agent.rt_jzhc14.core.instr.Instrumenter;
import org.jacoco.agent.rt_jzhc14.core.runtime.AgentOptions;
import org.jacoco.agent.rt_jzhc14.core.runtime.IRuntime;
import org.jacoco.agent.rt_jzhc14.core.runtime.WildcardMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageTransformer
implements ClassFileTransformer {
    private static final String AGENT_PREFIX;
    private final IExceptionLogger logger;
    private final Instrumenter instrumenter;
    private final WildcardMatcher includes;
    private final WildcardMatcher excludes;
    private final WildcardMatcher exclClassloader;

    public CoverageTransformer(IRuntime runtime, AgentOptions options, IExceptionLogger logger) {
        this.instrumenter = new Instrumenter(runtime);
        this.logger = logger;
        this.includes = new WildcardMatcher(this.toWildcard(CoverageTransformer.toVMName(options.getIncludes())));
        this.excludes = new WildcardMatcher(this.toWildcard(CoverageTransformer.toVMName(options.getExcludes())));
        this.exclClassloader = new WildcardMatcher(this.toWildcard(options.getExclClassloader()));
    }

    @Override
    public byte[] transform(ClassLoader loader, String classname, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (!this.filter(loader, classname)) {
            return null;
        }
        try {
            return this.instrumenter.instrument(classfileBuffer);
        }
        catch (Throwable t) {
            String msg = "Error while instrumenting class %s.";
            IllegalClassFormatException ex = new IllegalClassFormatException(String.format("Error while instrumenting class %s.", classname));
            this.logger.logExeption(ex);
            throw (IllegalClassFormatException)ex.initCause(t);
        }
    }

    protected boolean filter(ClassLoader loader, String classname) {
        return loader != null && !classname.startsWith(AGENT_PREFIX) && !this.exclClassloader.matches(loader.getClass().getName()) && this.includes.matches(classname) && !this.excludes.matches(classname);
    }

    private String toWildcard(String src) {
        if (src.indexOf(124) != -1) {
            IllegalArgumentException ex = new IllegalArgumentException("Usage of '|' as a list separator for JaCoCo agent options is deprecated and will not work in future versions - use ':' instead.");
            this.logger.logExeption(ex);
            return src.replace('|', ':');
        }
        return src;
    }

    private static String toVMName(String srcName) {
        return srcName.replace('.', '/');
    }

    static {
        String name = CoverageTransformer.class.getName();
        AGENT_PREFIX = CoverageTransformer.toVMName(name.substring(0, name.lastIndexOf(46)));
    }
}

