/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.core;

import org.infinispan.server.test.core.AbstractInfinispanServerDriver;
import org.infinispan.server.test.core.ContainerInfinispanServerDriver;
import org.infinispan.server.test.core.EmbeddedInfinispanServerDriver;
import org.infinispan.server.test.core.ForkedInfinispanServerDriver;
import org.infinispan.server.test.core.InfinispanServerTestConfiguration;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ServerRunMode {
    EMBEDDED{

        @Override
        public AbstractInfinispanServerDriver newDriver(InfinispanServerTestConfiguration configuration) {
            return new EmbeddedInfinispanServerDriver(configuration);
        }
    }
    ,
    CONTAINER{

        @Override
        public AbstractInfinispanServerDriver newDriver(InfinispanServerTestConfiguration configuration) {
            return new ContainerInfinispanServerDriver(configuration);
        }
    }
    ,
    FORKED{

        @Override
        public AbstractInfinispanServerDriver newDriver(InfinispanServerTestConfiguration configuration) {
            return new ForkedInfinispanServerDriver(configuration);
        }
    }
    ,
    DEFAULT{

        @Override
        public AbstractInfinispanServerDriver newDriver(InfinispanServerTestConfiguration configuration) {
            ServerRunMode driver;
            if (configuration.properties().containsKey("org.infinispan.test.server.container.baseImageName")) {
                driver = CONTAINER;
            } else {
                String driverName = configuration.properties().getProperty("org.infinispan.test.server.driver", EMBEDDED.name());
                driver = ServerRunMode.valueOf(driverName);
            }
            return driver.newDriver(configuration);
        }
    };


    public abstract AbstractInfinispanServerDriver newDriver(InfinispanServerTestConfiguration var1);
}

