/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.locking;

import jakarta.transaction.Transaction;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IsolationLevel;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.locking.SizeDistTxRepeatableReadTest")
public class SizeDistTxRepeatableReadTest
extends MultipleCacheManagersTest {
    IsolationLevel isolation = IsolationLevel.REPEATABLE_READ;
    Object k0;
    Object k1;

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder conf = SizeDistTxRepeatableReadTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        conf.clustering().hash().numOwners(1).locking().isolationLevel(this.isolation).transaction().lockingMode(LockingMode.OPTIMISTIC).transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup());
        this.createCluster(TestDataSCI.INSTANCE, conf, 2);
        this.waitForClusterToForm();
        this.k0 = this.getKeyForCache(0);
        this.k1 = this.getKeyForCache(1);
    }

    public void testSizeWithPreviousRead() throws Exception {
        this.preloadCacheAndCheckSize();
        this.tm(0).begin();
        AssertJUnit.assertEquals((Object)"v1", (Object)this.cache(0).get(this.k1));
        Transaction tx1 = this.tm(0).suspend();
        this.tm(0).begin();
        this.cache(0).remove(this.k1);
        this.cache(0).put(this.k0, (Object)"v2");
        this.tm(0).commit();
        AssertJUnit.assertEquals((int)1, (int)this.cache(0).size());
        AssertJUnit.assertEquals((Object)"v2", (Object)this.cache(0).get(this.k0));
        this.tm(0).resume(tx1);
        AssertJUnit.assertEquals((int)2, (int)this.cache(0).size());
        AssertJUnit.assertEquals((Object)"v2", (Object)this.cache(0).get(this.k0));
        AssertJUnit.assertEquals((Object)"v1", (Object)this.cache(0).get(this.k1));
        this.tm(0).commit();
        AssertJUnit.assertNull((Object)this.cache(1).get(this.k1));
    }

    public void testSizeWithReadFromRemoteNode() throws Exception {
        this.preloadCacheAndCheckSize();
        this.tm(0).begin();
        AssertJUnit.assertEquals((Object)"v1", (Object)this.cache(0).get(this.k1));
        AssertJUnit.assertEquals((int)2, (int)this.cache(0).size());
        this.tm(0).rollback();
    }

    public void testSizeWithoutPreviousRead() throws Exception {
        this.preloadCacheAndCheckSize();
        this.tm(0).begin();
        Transaction tx1 = this.tm(0).suspend();
        this.tm(0).begin();
        this.cache(0).remove(this.k1);
        this.cache(0).put(this.k0, (Object)"v2");
        this.tm(0).commit();
        AssertJUnit.assertEquals((int)1, (int)this.cache(0).size());
        AssertJUnit.assertEquals((Object)"v2", (Object)this.cache(0).get(this.k0));
        this.tm(0).resume(tx1);
        AssertJUnit.assertEquals((int)1, (int)this.cache(0).size());
        AssertJUnit.assertEquals((Object)"v2", (Object)this.cache(0).get(this.k0));
        AssertJUnit.assertNull((Object)this.cache(0).get(this.k1));
        this.tm(0).commit();
        AssertJUnit.assertNull((Object)this.cache(1).get(this.k1));
    }

    protected void preloadCacheAndCheckSize() throws Exception {
        this.tm(0).begin();
        this.cache(0).put(this.k0, (Object)"v0");
        this.cache(0).put(this.k1, (Object)"v1");
        AssertJUnit.assertEquals((int)2, (int)this.cache(0).size());
        this.tm(0).commit();
    }
}

