/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.transaction.LockingMode;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.LockReleaseWithNoWriteTest")
public class LockReleaseWithNoWriteTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder dcc = LockReleaseWithNoWriteTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        dcc.transaction().lockingMode(LockingMode.PESSIMISTIC);
        this.createCluster(TestDataSCI.INSTANCE, dcc, 2);
        this.waitForClusterToForm();
    }

    public void testLocksReleased1() throws Exception {
        this.runtTest(1, 0);
    }

    public void testLocksReleased2() throws Exception {
        this.runtTest(1, 1);
    }

    public void testLocksReleased3() throws Exception {
        this.runtTest(0, 0);
    }

    public void testLocksReleased4() throws Exception {
        this.runtTest(0, 1);
    }

    private void runtTest(int lockOwner, int txOwner) throws NotSupportedException, SystemException, RollbackException, HeuristicMixedException, HeuristicRollbackException {
        Object key = this.getKeyForCache(lockOwner);
        this.tm(txOwner).begin();
        this.advancedCache(txOwner).lock(new Object[]{key});
        this.tm(txOwner).commit();
        this.assertNotLocked(key);
    }
}

