/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener;

import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.notifications.cachelistener.filter.EventType;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="notifications.cachelistener.FilterListenerTest")
public class FilterListenerTest
extends AbstractInfinispanTest {
    public void testLocal() throws IOException {
        this.test(false);
    }

    public void testSimple() throws IOException {
        this.test(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void test(boolean simple) throws IOException {
        GlobalConfiguration global = new GlobalConfigurationBuilder().nonClusteredDefault().build();
        Configuration local = new ConfigurationBuilder().clustering().cacheMode(CacheMode.LOCAL).simpleCache(simple).build();
        try (DefaultCacheManager manager = new DefaultCacheManager(global);){
            manager.defineConfiguration("local", local);
            Cache cache = manager.getCache("local");
            TestListener listener = new TestListener();
            cache.addListener((Object)listener, (CacheEventFilter)listener, null);
            cache.put((Object)"foo", (Object)"bar");
            cache.put((Object)1, (Object)2);
            try {
                AssertJUnit.assertEquals((int)1, (int)listener.events.size());
                AssertJUnit.assertEquals((Object)"foo", (Object)listener.events.remove());
            }
            finally {
                cache.removeListener((Object)listener);
                cache.stop();
            }
        }
    }

    @Listener
    public static class TestListener
    implements CacheEventFilter<Object, Object> {
        private final Queue<Object> events = new LinkedBlockingQueue<Object>();

        @CacheEntryCreated
        public void onEvent(CacheEntryCreatedEvent<Object, Object> event) {
            if (!event.isPre()) {
                this.events.add(event.getKey());
            }
        }

        public boolean accept(Object key, Object oldValue, Metadata oldMetadata, Object newValue, Metadata newMetadata, EventType eventType) {
            return key instanceof String;
        }
    }
}

