/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.Cache;
import org.infinispan.commands.write.IracPutKeyValueCommand;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.jmx.TestMBeanServerLookup;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.distribution.BlockingInterceptor;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.XSiteResponse;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.AbstractDelegatingRpcManager;
import org.infinispan.xsite.AbstractMultipleSitesTest;
import org.infinispan.xsite.XSiteBackup;
import org.infinispan.xsite.commands.remote.XSiteCacheRequest;
import org.infinispan.xsite.irac.ManualIracManager;
import org.infinispan.xsite.spi.AlwaysRemoveXSiteEntryMergePolicy;
import org.infinispan.xsite.spi.DefaultXSiteEntryMergePolicy;
import org.infinispan.xsite.spi.XSiteEntryMergePolicy;
import org.infinispan.xsite.statetransfer.XSiteStateTransferManager;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="jmx.XSiteMBeanTest")
public class XSiteMBeanTest
extends AbstractMultipleSitesTest {
    private static final int N_SITES = 2;
    private static final int CLUSTER_SIZE = 1;
    private final MBeanServerLookup mBeanServerLookup = TestMBeanServerLookup.create();
    private final List<ManualIracManager> iracManagerList = new ArrayList<ManualIracManager>(2);
    private final List<ManualRpcManager> rpcManagerList = new ArrayList<ManualRpcManager>(2);
    private final List<BlockingInterceptor<IracPutKeyValueCommand>> blockingInterceptorList = new ArrayList<BlockingInterceptor<IracPutKeyValueCommand>>(2);

    @Override
    @AfterClass(alwaysRun=true)
    protected void destroy() {
        super.destroy();
        this.iracManagerList.clear();
        this.rpcManagerList.clear();
        this.blockingInterceptorList.clear();
    }

    private static void assertSameAttributeAndOperation(MBeanServer mBeanServer, ObjectName objectName, Attribute attribute, String site) throws Exception {
        long val1 = XSiteMBeanTest.invokeLongAttribute(mBeanServer, objectName, attribute);
        long val2 = XSiteMBeanTest.invokeLongOperation(mBeanServer, objectName, attribute, site);
        log.debugf("%s op(%s) = %d", (Object)objectName, (Object)attribute, (Object)val2);
        AssertJUnit.assertEquals((String)("Wrong value for " + String.valueOf((Object)attribute)), (long)val1, (long)val2);
    }

    private static void assertAttribute(MBeanServer mBeanServer, ObjectName objectName, Attribute attribute, long expected) throws Exception {
        long val = XSiteMBeanTest.invokeLongAttribute(mBeanServer, objectName, attribute);
        AssertJUnit.assertEquals((String)("Wrong attribute value for " + String.valueOf((Object)attribute)), (long)expected, (long)val);
    }

    private static void eventuallyAssertAttribute(MBeanServer mBeanServer, ObjectName objectName, Attribute attribute) {
        Supplier<Long> s = () -> {
            try {
                return XSiteMBeanTest.invokeLongAttribute(mBeanServer, objectName, attribute);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
        XSiteMBeanTest.eventuallyEquals("Wrong attribute " + String.valueOf((Object)attribute), 1L, s);
    }

    private static void assertHasAttribute(MBeanServer mBeanServer, ObjectName objectName, Attribute attribute) throws Exception {
        long val = XSiteMBeanTest.invokeLongAttribute(mBeanServer, objectName, attribute);
        if (val == -1L) {
            AssertJUnit.fail((String)("Attribute " + String.valueOf((Object)attribute) + " expected to exist but it is -1."));
        }
    }

    private static void assertOperation(MBeanServer mBeanServer, ObjectName objectName, Attribute attribute, String site, long expected) throws Exception {
        long val = XSiteMBeanTest.invokeLongOperation(mBeanServer, objectName, attribute, site);
        log.debugf("%s op(%s) = %d", (Object)objectName, (Object)attribute, (Object)val);
        AssertJUnit.assertEquals((String)("Wrong operation value for " + String.valueOf((Object)attribute)), (long)expected, (long)val);
    }

    private static long invokeLongOperation(MBeanServer mBeanServer, ObjectName rpcManager, Attribute attribute, String siteName) throws Exception {
        Object val = mBeanServer.invoke(rpcManager, attribute.operationName, new Object[]{siteName}, new String[]{String.class.getName()});
        AssertJUnit.assertTrue((boolean)(val instanceof Number));
        return ((Number)val).longValue();
    }

    private static long invokeLongAttribute(MBeanServer mBeanServer, ObjectName objectName, Attribute attribute) throws Exception {
        Object val = mBeanServer.getAttribute(objectName, attribute.attributeName);
        log.debugf("%s attr(%s) = %d", (Object)objectName, (Object)attribute, val);
        AssertJUnit.assertTrue((boolean)(val instanceof Number));
        return ((Number)val).longValue();
    }

    private static int invokeQueueSizeAttribute(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        Object val = mBeanServer.getAttribute(objectName, Attribute.QUEUE_SIZE.attributeName);
        AssertJUnit.assertTrue((boolean)(val instanceof Number));
        return ((Number)val).intValue();
    }

    private static ManualRpcManager wrapRpcManager(Cache<?, ?> cache) {
        RpcManager rpcManager = TestingUtil.extractComponent(cache, RpcManager.class);
        if (rpcManager instanceof ManualRpcManager) {
            return (ManualRpcManager)rpcManager;
        }
        return TestingUtil.wrapComponent(cache, RpcManager.class, ManualRpcManager::new);
    }

    public void testRequestsSent(Method method) throws Exception {
        String key = TestingUtil.k(method);
        String value = TestingUtil.v(method);
        Cache cache = this.cache(0, 0);
        MBeanServer mBeanServer = this.mBeanServerLookup.getMBeanServer();
        ObjectName rpcManager = this.getRpcManagerObjectName(0);
        AssertJUnit.assertTrue((boolean)mBeanServer.isRegistered(rpcManager));
        this.resetRpcManagerStats(mBeanServer, rpcManager);
        cache.put((Object)TestingUtil.k(method), (Object)TestingUtil.v(method));
        this.assertEventuallyInSite(this.siteName(1), cache1 -> Objects.equals(value, cache1.get((Object)key)), 10L, TimeUnit.SECONDS);
        this.awaitUntilKeysSent();
        XSiteMBeanTest.assertAttribute(mBeanServer, rpcManager, Attribute.REQ_SENT, 1L);
        XSiteMBeanTest.assertOperation(mBeanServer, rpcManager, Attribute.REQ_SENT, this.siteName(1), 1L);
        XSiteMBeanTest.assertHasAttribute(mBeanServer, rpcManager, Attribute.MIN_TIME);
        XSiteMBeanTest.assertHasAttribute(mBeanServer, rpcManager, Attribute.AVG_TIME);
        XSiteMBeanTest.assertHasAttribute(mBeanServer, rpcManager, Attribute.MAX_TIME);
        XSiteMBeanTest.assertSameAttributeAndOperation(mBeanServer, rpcManager, Attribute.MIN_TIME, this.siteName(1));
        XSiteMBeanTest.assertSameAttributeAndOperation(mBeanServer, rpcManager, Attribute.AVG_TIME, this.siteName(1));
        XSiteMBeanTest.assertSameAttributeAndOperation(mBeanServer, rpcManager, Attribute.MAX_TIME, this.siteName(1));
        AssertJUnit.assertEquals((long)XSiteMBeanTest.invokeLongAttribute(mBeanServer, rpcManager, Attribute.MIN_TIME), (long)XSiteMBeanTest.invokeLongAttribute(mBeanServer, rpcManager, Attribute.MAX_TIME));
        AssertJUnit.assertEquals((long)XSiteMBeanTest.invokeLongAttribute(mBeanServer, rpcManager, Attribute.MIN_TIME), (long)XSiteMBeanTest.invokeLongAttribute(mBeanServer, rpcManager, Attribute.AVG_TIME));
        this.resetRpcManagerStats(mBeanServer, rpcManager);
    }

    public void testRequestsReceived(Method method) throws Exception {
        String key = TestingUtil.k(method);
        String value = TestingUtil.v(method);
        Cache cache = this.cache(0, 0);
        MBeanServer mBeanServer = this.mBeanServerLookup.getMBeanServer();
        ObjectName rpcManager = this.getRpcManagerObjectName(1);
        AssertJUnit.assertTrue((boolean)mBeanServer.isRegistered(rpcManager));
        this.resetRpcManagerStats(mBeanServer, rpcManager);
        cache.put((Object)TestingUtil.k(method), (Object)TestingUtil.v(method));
        this.assertEventuallyInSite(this.siteName(1), cache1 -> Objects.equals(value, cache1.get((Object)key)), 10L, TimeUnit.SECONDS);
        this.awaitUntilKeysSent();
        XSiteMBeanTest.assertAttribute(mBeanServer, rpcManager, Attribute.REQ_RECV, 1L);
        XSiteMBeanTest.assertOperation(mBeanServer, rpcManager, Attribute.REQ_RECV, this.siteName(0), 1L);
        this.resetRpcManagerStats(mBeanServer, rpcManager);
    }

    public void testQueueSizeStats() throws Exception {
        MBeanServer mBeanServer = this.mBeanServerLookup.getMBeanServer();
        ObjectName iracManager = this.getIracManagerObjectName(0);
        AssertJUnit.assertTrue((boolean)mBeanServer.isRegistered(iracManager));
        AssertJUnit.assertEquals((int)0, (int)XSiteMBeanTest.invokeQueueSizeAttribute(mBeanServer, iracManager));
        ManualRpcManager rpcManager = this.rpcManagerList.get(0);
        BlockedRequest req = rpcManager.block();
        this.cache(0, 0).put((Object)"key", (Object)"value");
        req.awaitRequest();
        AssertJUnit.assertEquals((int)1, (int)XSiteMBeanTest.invokeQueueSizeAttribute(mBeanServer, iracManager));
        rpcManager.unblock();
        this.eventuallyAssertInAllSitesAndCaches(cache -> Objects.equals("value", cache.get((Object)"key")));
        this.awaitUntilKeysSent();
        AssertJUnit.assertEquals((int)0, (int)XSiteMBeanTest.invokeQueueSizeAttribute(mBeanServer, iracManager));
        XSiteMBeanTest.setStatisticsEnabled(mBeanServer, iracManager, false);
        AssertJUnit.assertEquals((int)-1, (int)XSiteMBeanTest.invokeQueueSizeAttribute(mBeanServer, iracManager));
        XSiteMBeanTest.setStatisticsEnabled(mBeanServer, iracManager, true);
    }

    public void testNumberOfConflictsStats() throws Exception {
        MBeanServer mBeanServer = this.mBeanServerLookup.getMBeanServer();
        ObjectName iracManager1 = this.getIracManagerObjectName(0);
        ObjectName iracManager2 = this.getIracManagerObjectName(1);
        AssertJUnit.assertTrue((boolean)mBeanServer.isRegistered(iracManager1));
        AssertJUnit.assertTrue((boolean)mBeanServer.isRegistered(iracManager2));
        XSiteMBeanTest.assertAttribute(mBeanServer, iracManager1, Attribute.CONFLICTS, 0L);
        XSiteMBeanTest.assertAttribute(mBeanServer, iracManager2, Attribute.CONFLICTS, 0L);
        this.createConflict(false);
        XSiteMBeanTest.eventuallyAssertAttribute(mBeanServer, iracManager1, Attribute.CONFLICTS);
        XSiteMBeanTest.eventuallyAssertAttribute(mBeanServer, iracManager2, Attribute.CONFLICTS);
        XSiteMBeanTest.assertAttribute(mBeanServer, iracManager1, Attribute.CONFLICT_LOCAL, 1L);
        XSiteMBeanTest.assertAttribute(mBeanServer, iracManager2, Attribute.CONFLICT_LOCAL, 0L);
        XSiteMBeanTest.assertAttribute(mBeanServer, iracManager1, Attribute.CONFLICT_REMOTE, 0L);
        XSiteMBeanTest.assertAttribute(mBeanServer, iracManager2, Attribute.CONFLICT_REMOTE, 1L);
        XSiteMBeanTest.assertAttribute(mBeanServer, iracManager1, Attribute.CONFLICT_MERGED, 0L);
        XSiteMBeanTest.assertAttribute(mBeanServer, iracManager2, Attribute.CONFLICT_MERGED, 0L);
        this.awaitUntilKeysSent();
        for (ObjectName objectName : Arrays.asList(iracManager1, iracManager2)) {
            XSiteMBeanTest.resetIracManagerStats(mBeanServer, objectName);
            XSiteMBeanTest.setStatisticsEnabled(mBeanServer, objectName, false);
            XSiteMBeanTest.assertAttribute(mBeanServer, objectName, Attribute.CONFLICTS, -1L);
            XSiteMBeanTest.assertAttribute(mBeanServer, objectName, Attribute.CONFLICT_LOCAL, -1L);
            XSiteMBeanTest.assertAttribute(mBeanServer, objectName, Attribute.CONFLICT_REMOTE, -1L);
            XSiteMBeanTest.setStatisticsEnabled(mBeanServer, objectName, true);
        }
    }

    public void testNumberOfConflictMerged() throws Exception {
        MBeanServer mBeanServer = this.mBeanServerLookup.getMBeanServer();
        ObjectName iracManager1 = this.getIracManagerObjectName(0);
        ObjectName iracManager2 = this.getIracManagerObjectName(1);
        AssertJUnit.assertTrue((boolean)mBeanServer.isRegistered(iracManager1));
        AssertJUnit.assertTrue((boolean)mBeanServer.isRegistered(iracManager2));
        TestingUtil.replaceComponent(this.cache(0, 0), XSiteEntryMergePolicy.class, AlwaysRemoveXSiteEntryMergePolicy.getInstance(), true);
        TestingUtil.replaceComponent(this.cache(1, 0), XSiteEntryMergePolicy.class, AlwaysRemoveXSiteEntryMergePolicy.getInstance(), true);
        XSiteMBeanTest.assertAttribute(mBeanServer, iracManager1, Attribute.CONFLICT_MERGED, 0L);
        XSiteMBeanTest.assertAttribute(mBeanServer, iracManager2, Attribute.CONFLICT_MERGED, 0L);
        this.createConflict(true);
        XSiteMBeanTest.eventuallyAssertAttribute(mBeanServer, iracManager1, Attribute.CONFLICT_MERGED);
        XSiteMBeanTest.eventuallyAssertAttribute(mBeanServer, iracManager2, Attribute.CONFLICT_MERGED);
        TestingUtil.replaceComponent(this.cache(0, 0), XSiteEntryMergePolicy.class, DefaultXSiteEntryMergePolicy.getInstance(), true);
        TestingUtil.replaceComponent(this.cache(1, 0), XSiteEntryMergePolicy.class, DefaultXSiteEntryMergePolicy.getInstance(), true);
        this.awaitUntilKeysSent();
        for (ObjectName objectName : Arrays.asList(iracManager1, iracManager2)) {
            XSiteMBeanTest.resetIracManagerStats(mBeanServer, objectName);
            XSiteMBeanTest.setStatisticsEnabled(mBeanServer, objectName, false);
            XSiteMBeanTest.assertAttribute(mBeanServer, objectName, Attribute.CONFLICT_MERGED, -1L);
            XSiteMBeanTest.setStatisticsEnabled(mBeanServer, objectName, true);
        }
    }

    public void testNumberOfDiscardsStats() throws Throwable {
        MBeanServer mBeanServer = this.mBeanServerLookup.getMBeanServer();
        ObjectName iracManager = this.getIracManagerObjectName(1);
        AssertJUnit.assertTrue((boolean)mBeanServer.isRegistered(iracManager));
        XSiteMBeanTest.assertAttribute(mBeanServer, iracManager, Attribute.DISCARDS, 0L);
        this.createDiscard();
        XSiteMBeanTest.assertAttribute(mBeanServer, iracManager, Attribute.DISCARDS, 1L);
        this.awaitUntilKeysSent();
        XSiteMBeanTest.resetIracManagerStats(mBeanServer, iracManager);
        XSiteMBeanTest.setStatisticsEnabled(mBeanServer, iracManager, false);
        XSiteMBeanTest.assertAttribute(mBeanServer, iracManager, Attribute.DISCARDS, -1L);
        XSiteMBeanTest.setStatisticsEnabled(mBeanServer, iracManager, true);
    }

    @Override
    protected int defaultNumberOfSites() {
        return 2;
    }

    @Override
    protected int defaultNumberOfNodes() {
        return 1;
    }

    @Override
    protected ConfigurationBuilder defaultConfigurationForSite(int siteIndex) {
        ConfigurationBuilder builder = XSiteMBeanTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC);
        for (int i = 0; i < 2; ++i) {
            if (i == siteIndex) continue;
            builder.sites().addBackup().site(this.siteName(i)).strategy(BackupConfiguration.BackupStrategy.ASYNC);
        }
        builder.statistics().enable();
        return builder;
    }

    @Override
    protected GlobalConfigurationBuilder defaultGlobalConfigurationForSite(int siteIndex) {
        GlobalConfigurationBuilder builder = GlobalConfigurationBuilder.defaultClusteredBuilder();
        builder.serialization().addContextInitializer((SerializationContextInitializer)TestDataSCI.INSTANCE);
        builder.cacheContainer().statistics(true).jmx().enable().domain("xsite-mbean-" + siteIndex).mBeanServerLookup(this.mBeanServerLookup).metrics().accurateSize(true);
        return builder;
    }

    @Override
    protected void afterSitesCreated() {
        for (int i = 0; i < 2; ++i) {
            for (Cache cache : this.caches(this.siteName(i))) {
                this.rpcManagerList.add(XSiteMBeanTest.wrapRpcManager(cache));
                this.iracManagerList.add(ManualIracManager.wrapCache(cache));
                BlockingInterceptor<IracPutKeyValueCommand> interceptor = new BlockingInterceptor<IracPutKeyValueCommand>(new CyclicBarrier(2), IracPutKeyValueCommand.class, false, false);
                interceptor.suspend(true);
                this.blockingInterceptorList.add(interceptor);
                TestingUtil.extractInterceptorChain(cache).addInterceptor(interceptor, 0);
            }
        }
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void clearContent() throws Throwable {
        this.rpcManagerList.forEach(ManualRpcManager::unblock);
        this.iracManagerList.forEach(m -> m.disable(ManualIracManager.DisableMode.DROP));
        this.blockingInterceptorList.forEach(i -> i.suspend(true));
        super.clearContent();
    }

    private void awaitUntilKeysSent() {
        AssertJUnit.assertEquals((int)1, (int)this.defaultNumberOfNodes());
        ManualIracManager iracManager = this.iracManagerList.get(0);
        XSiteMBeanTest.eventually(iracManager::isEmpty);
    }

    private void createConflict(boolean isConflictMerged) {
        String key = "conflict-key";
        this.cache(0, 0).put((Object)"conflict-key", (Object)"value1");
        this.eventuallyAssertInAllSitesAndCaches(cache -> Objects.equals("value1", cache.get((Object)"conflict-key")));
        this.iracManagerList.forEach(ManualIracManager::enable);
        this.blockingInterceptorList.forEach(i -> i.suspend(false));
        this.cache(0, 0).put((Object)"conflict-key", (Object)"v-2");
        this.cache(1, 0).put((Object)"conflict-key", (Object)"v-3");
        this.iracManagerList.forEach(manualIracManager -> manualIracManager.disable(ManualIracManager.DisableMode.SEND));
        this.blockingInterceptorList.forEach(i -> {
            try {
                i.proceed();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        this.blockingInterceptorList.forEach(i -> i.suspend(true));
        this.blockingInterceptorList.forEach(i -> {
            try {
                i.proceed();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        if (isConflictMerged) {
            this.eventuallyAssertInAllSitesAndCaches(cache -> Objects.isNull(cache.get((Object)"conflict-key")));
        } else {
            this.eventuallyAssertInAllSitesAndCaches(cache -> Objects.equals("v-2", cache.get((Object)"conflict-key")));
        }
    }

    private void createDiscard() throws Throwable {
        String key = "discard-key";
        this.cache(0, 0).put((Object)"discard-key", (Object)"value1");
        this.eventuallyAssertInAllSitesAndCaches(cache -> Objects.equals("value1", cache.get((Object)"discard-key")));
        TestingUtil.extractComponent(this.cache(0, 0), XSiteStateTransferManager.class).startPushState(this.siteName(1));
        this.assertEventuallyInSite(this.siteName(0), cache -> TestingUtil.extractComponent(cache, XSiteStateTransferManager.class).getRunningStateTransfers().isEmpty(), 10L, TimeUnit.SECONDS);
    }

    private void resetRpcManagerStats(MBeanServer mBeanServer, ObjectName rpcManager) throws Exception {
        mBeanServer.invoke(rpcManager, "resetStatistics", new Object[0], new String[0]);
        XSiteMBeanTest.assertAttribute(mBeanServer, rpcManager, Attribute.REQ_SENT, 0L);
        XSiteMBeanTest.assertAttribute(mBeanServer, rpcManager, Attribute.REQ_RECV, 0L);
        XSiteMBeanTest.assertAttribute(mBeanServer, rpcManager, Attribute.MIN_TIME, -1L);
        XSiteMBeanTest.assertAttribute(mBeanServer, rpcManager, Attribute.AVG_TIME, -1L);
        XSiteMBeanTest.assertAttribute(mBeanServer, rpcManager, Attribute.MAX_TIME, -1L);
        for (int i = 0; i < 2; ++i) {
            String site = this.siteName(i);
            XSiteMBeanTest.assertOperation(mBeanServer, rpcManager, Attribute.REQ_SENT, site, 0L);
            XSiteMBeanTest.assertOperation(mBeanServer, rpcManager, Attribute.REQ_RECV, site, 0L);
            XSiteMBeanTest.assertOperation(mBeanServer, rpcManager, Attribute.MIN_TIME, site, -1L);
            XSiteMBeanTest.assertOperation(mBeanServer, rpcManager, Attribute.AVG_TIME, site, -1L);
            XSiteMBeanTest.assertOperation(mBeanServer, rpcManager, Attribute.MAX_TIME, site, -1L);
        }
    }

    private static void resetIracManagerStats(MBeanServer mBeanServer, ObjectName iracManager) throws Exception {
        mBeanServer.invoke(iracManager, "resetStatistics", new Object[0], new String[0]);
        XSiteMBeanTest.assertAttribute(mBeanServer, iracManager, Attribute.CONFLICTS, 0L);
        XSiteMBeanTest.assertAttribute(mBeanServer, iracManager, Attribute.CONFLICT_LOCAL, 0L);
        XSiteMBeanTest.assertAttribute(mBeanServer, iracManager, Attribute.CONFLICT_REMOTE, 0L);
        XSiteMBeanTest.assertAttribute(mBeanServer, iracManager, Attribute.CONFLICT_MERGED, 0L);
        XSiteMBeanTest.assertAttribute(mBeanServer, iracManager, Attribute.DISCARDS, 0L);
    }

    private static void setStatisticsEnabled(MBeanServer mBeanServer, ObjectName objectName, boolean enabled) throws Exception {
        mBeanServer.setAttribute(objectName, new javax.management.Attribute("StatisticsEnabled", enabled));
    }

    private String getJmxDomain(int siteIndex) {
        return this.manager(siteIndex, 0).getCacheManagerConfiguration().jmx().domain();
    }

    private ObjectName getRpcManagerObjectName(int siteIndex) {
        return TestingUtil.getCacheObjectName(this.getJmxDomain(siteIndex), this.getDefaultCacheName() + "(dist_sync)", "RpcManager");
    }

    private ObjectName getIracManagerObjectName(int siteIndex) {
        return TestingUtil.getCacheObjectName(this.getJmxDomain(siteIndex), this.getDefaultCacheName() + "(dist_sync)", "AsyncXSiteStatistics");
    }

    private static enum Attribute {
        REQ_SENT("NumberXSiteRequests", "NumberXSiteRequestsSentTo"),
        REQ_RECV("NumberXSiteRequestsReceived", "NumberXSiteRequestsReceivedFrom"),
        AVG_TIME("AverageXSiteReplicationTime", "AverageXSiteReplicationTimeTo"),
        MAX_TIME("MaximumXSiteReplicationTime", "MaximumXSiteReplicationTimeTo"),
        MIN_TIME("MinimumXSiteReplicationTime", "MinimumXSiteReplicationTimeTo"),
        QUEUE_SIZE("QueueSize", null),
        CONFLICTS("NumberOfConflicts", null),
        CONFLICT_LOCAL("NumberOfConflictsLocalWins", null),
        CONFLICT_REMOTE("NumberOfConflictsRemoteWins", null),
        CONFLICT_MERGED("NumberOfConflictsMerged", null),
        DISCARDS("NumberOfDiscards", null);

        final String attributeName;
        final String operationName;

        private Attribute(String attributeName, String operationName) {
            this.attributeName = attributeName;
            this.operationName = operationName;
        }
    }

    private static class ManualRpcManager
    extends AbstractDelegatingRpcManager {
        private volatile BlockedRequest blockedRequest;

        ManualRpcManager(RpcManager realOne) {
            super(realOne);
        }

        @Override
        public <O> XSiteResponse<O> invokeXSite(XSiteBackup backup, XSiteCacheRequest<O> command) {
            BlockedRequest req = this.blockedRequest;
            if (req != null) {
                DummyXsiteResponse rsp = new DummyXsiteResponse();
                req.thenRun(() -> rsp.onRequest(super.invokeXSite(backup, command)));
                return rsp;
            }
            return super.invokeXSite(backup, command);
        }

        BlockedRequest block() {
            BlockedRequest req;
            this.blockedRequest = req = new BlockedRequest();
            return req;
        }

        void unblock() {
            BlockedRequest req = this.blockedRequest;
            if (req != null) {
                req.continueRequest();
                this.blockedRequest = null;
            }
        }
    }

    private static class BlockedRequest
    extends CompletableFuture<Void> {
        private final CountDownLatch latch = new CountDownLatch(1);

        private BlockedRequest() {
        }

        @Override
        public CompletableFuture<Void> thenRun(Runnable action) {
            this.latch.countDown();
            return super.thenRun(action);
        }

        void awaitRequest() throws InterruptedException {
            AssertJUnit.assertTrue((boolean)this.latch.await(10L, TimeUnit.SECONDS));
        }

        void continueRequest() {
            this.complete(null);
        }
    }

    private static class DummyXsiteResponse<O>
    extends CompletableFuture<O>
    implements XSiteResponse<O>,
    XSiteResponse.XSiteResponseCompleted {
        private volatile XSiteResponse<O> realOne;
        private volatile XSiteBackup backup;
        private volatile long sendTimeStamp;
        private volatile long durationNanos;

        private DummyXsiteResponse() {
        }

        public void onCompleted(XSiteBackup backup, long sendTimeNanos, long durationNanos, Throwable throwable) {
            this.backup = backup;
            this.sendTimeStamp = sendTimeNanos;
            this.durationNanos = durationNanos;
            if (throwable != null) {
                this.completeExceptionally(throwable);
            } else {
                this.complete(this.realOne.toCompletableFuture().join());
            }
        }

        public void whenCompleted(XSiteResponse.XSiteResponseCompleted xSiteResponseCompleted) {
            this.whenComplete((T ignore, U throwable) -> xSiteResponseCompleted.onCompleted(this.backup, this.sendTimeStamp, this.durationNanos, throwable));
        }

        void onRequest(XSiteResponse<O> response) {
            this.realOne = response;
            response.whenCompleted((XSiteResponse.XSiteResponseCompleted)this);
        }
    }
}

