/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.HashSet;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.DistributionTestHelper;
import org.infinispan.distribution.MagicKey;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.testng.annotations.Test;

@Test(testName="distribution.DistStoreTxDisjointSetTest", groups={"functional"})
public class DistStoreTxDisjointSetTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        TestDataSCI sci = TestDataSCI.INSTANCE;
        this.addClusterEnabledCacheManager(sci, this.buildCacheConfig("DistCacheStoreTxDisjointSetTest0"));
        this.addClusterEnabledCacheManager(sci, this.buildCacheConfig("DistCacheStoreTxDisjointSetTest1"));
        this.addClusterEnabledCacheManager(sci, this.buildCacheConfig("DistCacheStoreTxDisjointSetTest2"));
        this.waitForClusterToForm();
    }

    private ConfigurationBuilder buildCacheConfig(String storeName) {
        ConfigurationBuilder cb = DistStoreTxDisjointSetTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        ((DummyInMemoryStoreConfigurationBuilder)cb.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).storeName(storeName);
        return cb;
    }

    public void testDisjointSetTransaction() throws Exception {
        MagicKey k1 = new MagicKey(this.cache(0), this.cache(1));
        MagicKey k2 = new MagicKey(this.cache(1), this.cache(2));
        HashSet<Address> k1Owners = new HashSet<Address>();
        HashSet<Address> k2Owners = new HashSet<Address>();
        for (Cache cache : this.caches()) {
            if (DistributionTestHelper.isOwner(cache, k1)) {
                k1Owners.add(DistributionTestHelper.addressOf(cache));
            }
            if (!DistributionTestHelper.isOwner(cache, k2)) continue;
            k2Owners.add(DistributionTestHelper.addressOf(cache));
        }
        assert (k1Owners.size() == 2) : "Expected 2 owners for k1; was " + String.valueOf(k1Owners);
        assert (k2Owners.size() == 2) : "Expected 2 owners for k1; was " + String.valueOf(k2Owners);
        assert (!k1Owners.equals(k2Owners)) : String.format("k1 and k2 should have different ownership set.  Was %s and %s", k1Owners, k2Owners);
        this.tm(0).begin();
        this.cache(0).put((Object)k1, (Object)"v1");
        this.cache(0).put((Object)k2, (Object)"v2");
        this.tm(0).commit();
    }
}

