/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.dataconversion;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.infinispan.commons.dataconversion.Base16Codec;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.marshall.MarshallingException;
import org.infinispan.encoding.ProtostreamTranscoder;
import org.infinispan.marshall.protostream.impl.SerializationContextRegistry;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.data.Address;
import org.infinispan.test.data.Person;
import org.infinispan.test.dataconversion.AbstractTranscoderTest;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.testng.internal.junit.ArrayAsserts;

@Test(groups={"functional"}, testName="query.remote.impl.ProtostreamTranscoderTest")
public class ProtostreamTranscoderTest
extends AbstractTranscoderTest {
    protected String dataSrc;
    private final SerializationContext ctx = this.createCtx();
    static final MediaType UNWRAPPED_PROTOSTREAM = MediaType.APPLICATION_PROTOSTREAM.withParameter("wrapped", "false");
    static final MediaType TYPED_OBJECT = MediaType.APPLICATION_OBJECT.withParameter("type", Person.class.getName());

    @BeforeClass(alwaysRun=true)
    public void setUp() {
        this.dataSrc = " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~";
        SerializationContextRegistry registry = (SerializationContextRegistry)Mockito.mock(SerializationContextRegistry.class);
        Mockito.when((Object)registry.getUserCtx()).thenReturn((Object)this.ctx);
        this.transcoder = new ProtostreamTranscoder(registry, ProtostreamTranscoderTest.class.getClassLoader());
        this.supportedMediaTypes = this.transcoder.getSupportedMediaTypes();
    }

    private SerializationContext createCtx() {
        SerializationContext ctx = ProtobufUtil.newSerializationContext();
        TestDataSCI.INSTANCE.registerSchema(ctx);
        TestDataSCI.INSTANCE.registerMarshallers(ctx);
        return ctx;
    }

    @Override
    @Test
    public void testTranscoderTranscode() throws Exception {
        Object transcoded = this.transcoder.transcode((Object)this.dataSrc, MediaType.TEXT_PLAIN, MediaType.APPLICATION_PROTOSTREAM);
        Assert.assertTrue((boolean)(transcoded instanceof byte[]), (String)"Must be byte[]");
        Object transcodedBack = this.transcoder.transcode(transcoded, MediaType.APPLICATION_PROTOSTREAM, MediaType.TEXT_PLAIN);
        Assert.assertTrue((boolean)(transcodedBack instanceof byte[]), (String)"Must be instance of byte[]");
        Assert.assertEquals((String)this.dataSrc, (String)new String((byte[])transcodedBack, MediaType.TEXT_PLAIN.getCharset().name()), (String)"Must be equal strings");
    }

    @Test
    public void testWrappedMessage() throws IOException {
        Person input = new Person("value");
        byte[] wrapped = (byte[])this.transcoder.transcode((Object)input, MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_PROTOSTREAM);
        byte[] unwrapped = (byte[])this.transcoder.transcode((Object)input, MediaType.APPLICATION_OBJECT, UNWRAPPED_PROTOSTREAM);
        Assert.assertEquals((Object)input, (Object)ProtobufUtil.fromWrappedByteArray((ImmutableSerializationContext)this.ctx, (byte[])wrapped));
        Assert.assertEquals((Object)input, (Object)ProtobufUtil.fromByteArray((ImmutableSerializationContext)this.ctx, (byte[])unwrapped, Person.class));
        Object fromWrapped = this.transcoder.transcode((Object)wrapped, MediaType.APPLICATION_PROTOSTREAM, MediaType.APPLICATION_OBJECT);
        Assert.assertEquals((Object)input, (Object)fromWrapped);
        Object fromUnWrappedWithType = this.transcoder.transcode((Object)unwrapped, UNWRAPPED_PROTOSTREAM, TYPED_OBJECT);
        Assert.assertEquals((Object)input, (Object)fromUnWrappedWithType);
        try {
            this.transcoder.transcode((Object)unwrapped, UNWRAPPED_PROTOSTREAM, MediaType.APPLICATION_OBJECT);
            Assert.fail((String)"should not convert from unwrapped without type");
        }
        catch (MarshallingException marshallingException) {
            // empty catch block
        }
    }

    @Test
    public void testToFromObject() throws IOException {
        Person objectContent = new Person("value");
        byte[] marshalled = ProtobufUtil.toWrappedByteArray((ImmutableSerializationContext)this.ctx, (Object)objectContent);
        byte[] marshalledHex = Base16Codec.encode((byte[])marshalled).getBytes(StandardCharsets.UTF_8);
        Object result = this.transcoder.transcode((Object)objectContent, MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_PROTOSTREAM);
        ArrayAsserts.assertArrayEquals((byte[])marshalled, (byte[])((byte[])result));
        result = this.transcoder.transcode((Object)objectContent, MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_PROTOSTREAM.withEncoding("hex"));
        Assert.assertEquals((Object)Base16Codec.encode((byte[])marshalled), (Object)result);
        result = this.transcoder.transcode((Object)objectContent, MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_PROTOSTREAM.withEncoding("hex").withClassType(String.class));
        Assert.assertEquals((Object)Base16Codec.encode((byte[])marshalled), (Object)result);
        result = this.transcoder.transcode((Object)marshalled, MediaType.APPLICATION_PROTOSTREAM, MediaType.APPLICATION_OBJECT);
        Assert.assertEquals((Object)objectContent, (Object)result);
        result = this.transcoder.transcode((Object)marshalledHex, MediaType.APPLICATION_PROTOSTREAM.withEncoding("hex"), MediaType.APPLICATION_OBJECT);
        Assert.assertEquals((Object)objectContent, (Object)result);
    }

    @Test
    public void testToFromText() throws IOException {
        String string = "This is a text";
        byte[] textContent = "This is a text".getBytes(StandardCharsets.UTF_8);
        Object protoWithNoEncoding = this.transcoder.transcode((Object)textContent, MediaType.TEXT_PLAIN, MediaType.APPLICATION_PROTOSTREAM);
        ArrayAsserts.assertArrayEquals((byte[])ProtobufUtil.toWrappedByteArray((ImmutableSerializationContext)this.ctx, (Object)"This is a text"), (byte[])((byte[])protoWithNoEncoding));
        Object protoHex = this.transcoder.transcode((Object)textContent, MediaType.TEXT_PLAIN, MediaType.APPLICATION_PROTOSTREAM.withEncoding("hex"));
        Assert.assertEquals((Object)Base16Codec.encode((byte[])ProtobufUtil.toWrappedByteArray((ImmutableSerializationContext)this.ctx, (Object)"This is a text")), (Object)protoHex);
        Object protoBase64 = this.transcoder.transcode((Object)textContent, MediaType.TEXT_PLAIN, MediaType.APPLICATION_PROTOSTREAM.withEncoding("base64"));
        Assert.assertEquals((Object)Base64.getEncoder().encode(ProtobufUtil.toWrappedByteArray((ImmutableSerializationContext)this.ctx, (Object)"This is a text")), (Object)protoBase64);
        Object result = this.transcoder.transcode(protoWithNoEncoding, MediaType.APPLICATION_PROTOSTREAM, MediaType.TEXT_PLAIN);
        ArrayAsserts.assertArrayEquals((byte[])textContent, (byte[])((byte[])result));
    }

    @Test
    public void testToFromJson() throws IOException {
        String type = "org.infinispan.test.core.Address";
        String street = "Elm Street";
        String city = "NYC";
        int zip = 123;
        Address data = new Address(street, city, zip);
        String jsonString = Json.object().set("_type", (Object)type).set("street", (Object)street).set("city", (Object)city).set("zip", (Object)zip).toString();
        byte[] byteJson = jsonString.getBytes(StandardCharsets.UTF_8);
        Object protoWithNoEncoding = this.transcoder.transcode((Object)jsonString, MediaType.APPLICATION_JSON, MediaType.APPLICATION_PROTOSTREAM);
        ArrayAsserts.assertArrayEquals((byte[])ProtobufUtil.toWrappedByteArray((ImmutableSerializationContext)this.ctx, (Object)data), (byte[])((byte[])protoWithNoEncoding));
        Object protoHex = this.transcoder.transcode((Object)jsonString, MediaType.APPLICATION_JSON, MediaType.APPLICATION_PROTOSTREAM.withEncoding("hex"));
        Assert.assertEquals((Object)protoHex, (Object)Base16Codec.encode((byte[])((byte[])protoWithNoEncoding)));
        Object protoBase64 = this.transcoder.transcode((Object)jsonString, MediaType.APPLICATION_JSON, MediaType.APPLICATION_PROTOSTREAM.withEncoding("base64"));
        Assert.assertEquals((Object)protoBase64, (Object)Base64.getEncoder().encode((byte[])protoWithNoEncoding));
        protoWithNoEncoding = this.transcoder.transcode((Object)byteJson, MediaType.APPLICATION_JSON, MediaType.APPLICATION_PROTOSTREAM);
        ArrayAsserts.assertArrayEquals((byte[])ProtobufUtil.toWrappedByteArray((ImmutableSerializationContext)this.ctx, (Object)data), (byte[])((byte[])protoWithNoEncoding));
        protoHex = this.transcoder.transcode((Object)byteJson, MediaType.APPLICATION_JSON, MediaType.APPLICATION_PROTOSTREAM.withEncoding("hex"));
        Assert.assertEquals((Object)protoHex, (Object)Base16Codec.encode((byte[])((byte[])protoWithNoEncoding)));
        protoBase64 = this.transcoder.transcode((Object)byteJson, MediaType.APPLICATION_JSON, MediaType.APPLICATION_PROTOSTREAM.withEncoding("base64"));
        Assert.assertEquals((Object)protoBase64, (Object)Base64.getEncoder().encode((byte[])protoWithNoEncoding));
        Object result = this.transcoder.transcode(protoWithNoEncoding, MediaType.APPLICATION_PROTOSTREAM, MediaType.APPLICATION_JSON);
        Assert.assertTrue((boolean)(result instanceof byte[]));
        this.assertJsonCorrect(result);
        result = this.transcoder.transcode(protoHex, MediaType.APPLICATION_PROTOSTREAM.withEncoding("hex"), MediaType.APPLICATION_JSON);
        Assert.assertTrue((boolean)(result instanceof byte[]));
        this.assertJsonCorrect(result);
        result = this.transcoder.transcode(protoBase64, MediaType.APPLICATION_PROTOSTREAM.withEncoding("base64"), MediaType.APPLICATION_JSON);
        Assert.assertTrue((boolean)(result instanceof byte[]));
        this.assertJsonCorrect(result);
        result = this.transcoder.transcode(protoHex, MediaType.APPLICATION_PROTOSTREAM.withEncoding("hex"), MediaType.APPLICATION_JSON.withClassType(String.class));
        Assert.assertTrue((boolean)(result instanceof String));
        this.assertJsonCorrect(result);
    }

    private void assertJsonCorrect(Object json) {
        String strJson = json instanceof byte[] ? new String((byte[])json) : json.toString();
        Json jsonResult = Json.read((String)strJson);
        Assert.assertEquals((String)"org.infinispan.test.core.Address", (String)jsonResult.at("_type").asString());
    }
}

