/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.mvcc;

import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import java.lang.reflect.Method;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.MagicKey;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.BaseAsyncInterceptor;
import org.infinispan.interceptors.impl.CallInterceptor;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.ReplListener;
import org.infinispan.test.TestBlocking;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.InCacheMode;
import org.infinispan.test.fwk.InTransactionMode;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.impl.TransactionTable;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.mvcc.PutForExternalReadTest")
@CleanupAfterMethod
public class PutForExternalReadTest
extends MultipleCacheManagersTest {
    protected static final String CACHE_NAME = "pferSync";
    protected static final String key = "k";
    protected static final String value = "v1";
    protected static final String value2 = "v2";

    @Override
    public Object[] factory() {
        return new Object[]{new PutForExternalReadTest().cacheMode(CacheMode.DIST_SYNC).transactional(false), new PutForExternalReadTest().cacheMode(CacheMode.DIST_SYNC).transactional(true).lockingMode(LockingMode.OPTIMISTIC), new PutForExternalReadTest().cacheMode(CacheMode.DIST_SYNC).transactional(true).lockingMode(LockingMode.PESSIMISTIC), new PutForExternalReadTest().cacheMode(CacheMode.REPL_SYNC).transactional(false), new PutForExternalReadTest().cacheMode(CacheMode.REPL_SYNC).transactional(true).lockingMode(LockingMode.OPTIMISTIC), new PutForExternalReadTest().cacheMode(CacheMode.REPL_SYNC).transactional(true).lockingMode(LockingMode.PESSIMISTIC)};
    }

    @Override
    protected void createCacheManagers() {
        ConfigurationBuilder c = this.createCacheConfigBuilder();
        this.createClusteredCaches(2, CACHE_NAME, TestDataSCI.INSTANCE, c);
    }

    protected ConfigurationBuilder createCacheConfigBuilder() {
        ConfigurationBuilder c = PutForExternalReadTest.getDefaultClusteredCacheConfig(this.cacheMode, this.transactional);
        c.clustering().hash().numOwners(100);
        c.clustering().hash().numSegments(4);
        if (this.lockingMode != null) {
            c.transaction().lockingMode(this.lockingMode);
        }
        return c;
    }

    @InCacheMode(value={CacheMode.DIST_SYNC, CacheMode.REPL_SYNC})
    public void testKeyOnlyWrittenOnceOnOriginator() throws Exception {
        Cache cache1 = this.cache(0, CACHE_NAME);
        Cache cache2 = this.cache(1, CACHE_NAME);
        final CyclicBarrier barrier = new CyclicBarrier(2);
        TestingUtil.extractInterceptorChain(cache1).addInterceptor((AsyncInterceptor)new BaseAsyncInterceptor(this){
            final /* synthetic */ PutForExternalReadTest this$0;
            {
                this.this$0 = this$0;
            }

            public Object visitCommand(InvocationContext ctx, VisitableCommand command) throws Throwable {
                if (command instanceof PutKeyValueCommand && !ctx.isOriginLocal()) {
                    TestBlocking.await(barrier, 10L, TimeUnit.SECONDS);
                    TestBlocking.await(barrier, 10L, TimeUnit.SECONDS);
                }
                return this.invokeNext(ctx, command);
            }
        }, 0);
        MagicKey myKey = new MagicKey(cache2);
        cache1.putForExternalRead((Object)myKey, (Object)value);
        barrier.await(10L, TimeUnit.SECONDS);
        AssertJUnit.assertNull((Object)cache1.get((Object)myKey));
        barrier.await(10L, TimeUnit.SECONDS);
        PutForExternalReadTest.eventually(() -> value.equals(cache1.get((Object)myKey)) && value.equals(cache2.get((Object)myKey)));
    }

    public void testNoOpWhenKeyPresent() {
        Cache cache1 = this.cache(0, CACHE_NAME);
        Cache cache2 = this.cache(1, CACHE_NAME);
        cache1.putForExternalRead((Object)key, (Object)value);
        PutForExternalReadTest.eventually(() -> value.equals(cache1.get((Object)key)) && value.equals(cache2.get((Object)key)));
        cache1.remove((Object)key);
        PutForExternalReadTest.eventually(() -> cache1.isEmpty() && cache2.isEmpty());
        cache1.put((Object)key, (Object)value);
        PutForExternalReadTest.eventually(() -> value.equals(cache1.get((Object)key)) && value.equals(cache2.get((Object)key)));
        cache1.putForExternalRead((Object)key, (Object)value2);
        AssertJUnit.assertEquals((String)"PFER should have been a no-op", (String)value, (String)((String)cache1.get((Object)key)));
        AssertJUnit.assertEquals((String)"PFER should have been a no-op", (String)value, (String)((String)cache2.get((Object)key)));
    }

    @InTransactionMode(value={TransactionMode.TRANSACTIONAL})
    public void testTxSuspension() throws Exception {
        Cache cache1 = this.cache(0, CACHE_NAME);
        Cache cache2 = this.cache(1, CACHE_NAME);
        cache1.put((Object)"k0", (Object)value);
        PutForExternalReadTest.eventually(() -> value.equals(cache2.get((Object)"k0")));
        this.tm(0, CACHE_NAME).begin();
        cache1.get((Object)"k0");
        cache1.putForExternalRead((Object)key, (Object)value);
        Transaction t = this.tm(0, CACHE_NAME).suspend();
        PutForExternalReadTest.eventually(() -> value.equals(cache1.get((Object)key)) && value.equals(cache2.get((Object)key)));
        this.tm(0, CACHE_NAME).resume(t);
        this.tm(0, CACHE_NAME).commit();
        PutForExternalReadTest.eventually(() -> value.equals(cache1.get((Object)"k0")) && value.equals(cache2.get((Object)"k0")));
    }

    public void testExceptionSuppression() throws Exception {
        Cache cache1 = this.cache(0, CACHE_NAME);
        Cache cache2 = this.cache(1, CACHE_NAME);
        MagicKey key = new MagicKey(cache1);
        AssertJUnit.assertTrue((boolean)TestingUtil.extractInterceptorChain(cache1).addInterceptorBefore((AsyncInterceptor)new BaseAsyncInterceptor(){

            public Object visitCommand(InvocationContext ctx, VisitableCommand command) throws Throwable {
                if (command instanceof PutKeyValueCommand || command instanceof RemoveCommand) {
                    throw new RuntimeException("Barf!");
                }
                return this.invokeNext(ctx, command);
            }
        }, CallInterceptor.class));
        try {
            cache1.put((Object)key, (Object)value);
            AssertJUnit.fail((String)"Should have barfed");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            cache1.remove((Object)key);
            AssertJUnit.fail((String)"Should have barfed");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        AssertJUnit.assertNull((String)"Should have cleaned up", (Object)cache1.get((Object)key));
        AssertJUnit.assertNull((String)"Should have cleaned up", (Object)cache1.getAdvancedCache().getDataContainer().get((Object)key));
        AssertJUnit.assertNull((String)"Should have cleaned up", (Object)cache2.get((Object)key));
        InternalCacheEntry cache2Entry = cache2.getAdvancedCache().getDataContainer().get((Object)key);
        AssertJUnit.assertTrue((String)"Should have cleaned up", (cache2Entry == null ? 1 : 0) != 0);
        cache1.putForExternalRead((Object)key, (Object)value);
    }

    public void testBasicPropagation() throws Exception {
        Cache cache1 = this.cache(0, CACHE_NAME);
        Cache cache2 = this.cache(1, CACHE_NAME);
        AssertJUnit.assertFalse((boolean)cache1.containsKey((Object)key));
        AssertJUnit.assertFalse((boolean)cache2.containsKey((Object)key));
        ReplListener replListener2 = this.replListener(cache2);
        replListener2.expect((Class<? extends VisitableCommand>)PutKeyValueCommand.class);
        cache1.putForExternalRead((Object)key, (Object)value);
        replListener2.waitForRpc();
        PutForExternalReadTest.eventually(() -> cache1.containsKey((Object)key) && cache2.containsKey((Object)key));
        AssertJUnit.assertEquals((String)"PFER updated cache1", (String)value, (String)((String)cache1.get((Object)key)));
        AssertJUnit.assertEquals((String)"PFER propagated to cache2 as expected", (String)value, (String)((String)cache2.get((Object)key)));
        cache2.putForExternalRead((Object)key, (Object)"v10");
        AssertJUnit.assertEquals((String)"PFER updated cache2", (String)value, (String)((String)cache2.get((Object)key)));
        AssertJUnit.assertEquals((String)"Cache1 should be unaffected", (String)value, (String)((String)cache1.get((Object)key)));
    }

    public void testSimpleCacheModeLocal(Method m) throws Exception {
        this.cacheModeLocalTest(false, m);
    }

    @InTransactionMode(value={TransactionMode.TRANSACTIONAL})
    public void testCacheModeLocalInTx(Method m) throws Exception {
        this.cacheModeLocalTest(true, m);
    }

    @InTransactionMode(value={TransactionMode.TRANSACTIONAL})
    public void testMemLeakOnSuspendedTransactions() throws Exception {
        Cache cache1 = this.cache(0, CACHE_NAME);
        Cache cache2 = this.cache(1, CACHE_NAME);
        TransactionManager tm1 = TestingUtil.getTransactionManager(cache1);
        ReplListener replListener2 = this.replListener(cache2);
        replListener2.expect((Class<? extends VisitableCommand>)PutKeyValueCommand.class);
        tm1.begin();
        cache1.putForExternalRead((Object)key, (Object)value);
        tm1.commit();
        replListener2.waitForRpc();
        TransactionTable tt1 = TestingUtil.extractComponent(cache1, TransactionTable.class);
        TransactionTable tt2 = TestingUtil.extractComponent(cache2, TransactionTable.class);
        PutForExternalReadTest.eventually(() -> tt1.getRemoteTxCount() == 0 && tt1.getLocalTxCount() == 0 && tt2.getRemoteTxCount() == 0 && tt2.getLocalTxCount() == 0);
        replListener2.expectWithTx(PutKeyValueCommand.class);
        tm1.begin();
        AssertJUnit.assertEquals((int)tm1.getTransaction().getStatus(), (int)0);
        cache1.putForExternalRead((Object)key, (Object)value);
        AssertJUnit.assertEquals((int)tm1.getTransaction().getStatus(), (int)0);
        cache1.put((Object)key, (Object)value);
        AssertJUnit.assertEquals((int)tm1.getTransaction().getStatus(), (int)0);
        log.info((Object)"Before commit!!");
        tm1.commit();
        PutForExternalReadTest.eventually(() -> tt1.getRemoteTxCount() == 0 && tt1.getLocalTxCount() == 0 && tt2.getRemoteTxCount() == 0 && tt2.getLocalTxCount() == 0);
        replListener2.expectWithTx(PutKeyValueCommand.class);
        tm1.begin();
        cache1.put((Object)key, (Object)value);
        cache1.putForExternalRead((Object)key, (Object)value);
        tm1.commit();
        PutForExternalReadTest.eventually(() -> tt1.getRemoteTxCount() == 0 && tt1.getLocalTxCount() == 0 && tt2.getRemoteTxCount() == 0 && tt2.getLocalTxCount() == 0);
        replListener2.expectWithTx(PutKeyValueCommand.class, PutKeyValueCommand.class);
        tm1.begin();
        cache1.put((Object)key, (Object)value);
        cache1.putForExternalRead((Object)key, (Object)value);
        cache1.put((Object)key, (Object)value);
        tm1.commit();
        PutForExternalReadTest.eventually(() -> tt1.getRemoteTxCount() == 0 && tt1.getLocalTxCount() == 0 && tt2.getRemoteTxCount() == 0 && tt2.getLocalTxCount() == 0);
    }

    public void testMultipleIdenticalPutForExternalReadCalls() {
        Cache cache1 = this.cache(0, CACHE_NAME);
        Cache cache2 = this.cache(1, CACHE_NAME);
        cache1.putForExternalRead((Object)key, (Object)value);
        PutForExternalReadTest.eventually(() -> cache1.containsKey((Object)key) && cache2.containsKey((Object)key));
        cache1.putForExternalRead((Object)key, (Object)value2);
        AssertJUnit.assertEquals((String)value, (String)((String)cache1.get((Object)key)));
    }

    private void cacheModeLocalTest(boolean transactional, Method m) throws Exception {
        Cache cache1 = this.cache(0, CACHE_NAME);
        Cache cache2 = this.cache(1, CACHE_NAME);
        TransactionManager tm1 = TestingUtil.getTransactionManager(cache1);
        if (transactional) {
            tm1.begin();
        }
        String k = TestingUtil.k(m);
        cache1.getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL).putForExternalRead((Object)k, (Object)TestingUtil.v(m));
        AssertJUnit.assertTrue((boolean)cache1.getAdvancedCache().getDataContainer().containsKey((Object)k));
        AssertJUnit.assertFalse((boolean)cache2.getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL).containsKey((Object)k));
        AssertJUnit.assertFalse((boolean)cache2.getAdvancedCache().getDataContainer().containsKey((Object)k));
        if (transactional) {
            tm1.commit();
        }
    }
}

