/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.irac;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commons.time.ControlledTimeService;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IsolationLevel;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.TestOperation;
import org.infinispan.xsite.AbstractMultipleSitesTest;
import org.infinispan.xsite.irac.ManualIracManager;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(groups={"unstable"}, testName="xsite.irac.Irac3SitesConflictTest")
public class Irac3SitesConflictTest
extends AbstractMultipleSitesTest {
    private static final int N_SITES = 3;
    private static final int CLUSTER_SIZE = 3;
    private final List<ManualIracManager> iracManagerList = new ArrayList<ManualIracManager>(9);
    private ConfigMode configMode;

    public Irac3SitesConflictTest configMode(ConfigMode configMode) {
        this.configMode = configMode;
        return this;
    }

    @Factory
    public Object[] factory() {
        ArrayList<Irac3SitesConflictTest> tests = new ArrayList<Irac3SitesConflictTest>();
        for (ConfigMode configMode : ConfigMode.values()) {
            tests.add(new Irac3SitesConflictTest().configMode(configMode));
        }
        return tests.toArray();
    }

    @Override
    protected String[] parameterNames() {
        return new String[]{"configMode"};
    }

    @Override
    protected Object[] parameterValues() {
        return new Object[]{this.configMode};
    }

    protected Irac3SitesConflictTest() {
    }

    public void testPutIfAbsent(Method method) {
        this.doTest(method, new TestOperationInterop(TestOperation.PUT_IF_ABSENT));
    }

    public void testPut(Method method) {
        this.doTest(method, new TestOperationInterop(TestOperation.PUT));
    }

    public void testReplace(Method method) {
        this.doTest(method, new TestOperationInterop(TestOperation.REPLACE));
    }

    public void testConditionalReplace(Method method) {
        this.doTest(method, new TestOperationInterop(TestOperation.REPLACE_CONDITIONAL));
    }

    public void testRemove(Method method) {
        this.doTest(method, new TestOperationInterop(TestOperation.REMOVE));
    }

    public void testConditionalRemove(Method method) {
        this.doTest(method, new TestOperationInterop(TestOperation.REMOVE_CONDITIONAL));
    }

    public void testMaxIdleExpirationSync(Method method) {
        this.doTest(method, new RemoveExpiredOperation(this.replaceTimeService()));
    }

    private ControlledTimeService replaceTimeService() {
        ControlledTimeService timeService = new ControlledTimeService();
        for (int i = 0; i < 3; ++i) {
            String siteName = this.siteName(i);
            for (int j = 0; j < 3; ++j) {
                Cache c = this.cache(siteName, j);
                TestingUtil.replaceComponent((CacheContainer)c.getCacheManager(), TimeService.class, timeService, true);
            }
        }
        return timeService;
    }

    @Override
    protected int defaultNumberOfSites() {
        return 3;
    }

    @Override
    protected int defaultNumberOfNodes() {
        return 3;
    }

    @Override
    protected ConfigurationBuilder defaultConfigurationForSite(int siteIndex) {
        ConfigurationBuilder builder = Irac3SitesConflictTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, this.configMode != ConfigMode.NON_TX);
        switch (this.configMode.ordinal()) {
            case 2: {
                builder.transaction().lockingMode(LockingMode.OPTIMISTIC);
                builder.locking().isolationLevel(IsolationLevel.READ_COMMITTED);
                break;
            }
            case 3: {
                builder.transaction().lockingMode(LockingMode.OPTIMISTIC);
                builder.locking().isolationLevel(IsolationLevel.REPEATABLE_READ);
                break;
            }
            case 1: {
                builder.transaction().lockingMode(LockingMode.PESSIMISTIC);
            }
        }
        for (int i = 0; i < 3; ++i) {
            if (i == siteIndex) continue;
            builder.sites().addBackup().site(this.siteName(i)).strategy(BackupConfiguration.BackupStrategy.ASYNC);
        }
        return builder;
    }

    @Override
    protected GlobalConfigurationBuilder defaultGlobalConfigurationForSite(int siteIndex) {
        GlobalConfigurationBuilder builder = GlobalConfigurationBuilder.defaultClusteredBuilder();
        builder.serialization().addContextInitializer((SerializationContextInitializer)TestDataSCI.INSTANCE);
        return builder;
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void clearContent() throws Throwable {
        this.iracManagerList.forEach(iracManager -> iracManager.disable(ManualIracManager.DisableMode.DROP));
        super.clearContent();
    }

    @Override
    protected void afterSitesCreated() {
        for (int i = 0; i < 3; ++i) {
            for (Cache cache : this.caches(this.siteName(i))) {
                this.iracManagerList.add(ManualIracManager.wrapCache(cache));
            }
        }
    }

    private void doTest(Method method, IracTestOperation testConfig) {
        int i;
        String key = TestingUtil.k(method, 0);
        String initialValue = testConfig.insertValueAndReturnIfRequired(this.cache(this.siteName(0), 0), key, TestingUtil.v(method, 0));
        this.eventuallyAssertInAllSitesAndCaches(cache -> Objects.equals(initialValue, cache.get((Object)key)));
        this.iracManagerList.forEach(ManualIracManager::enable);
        String[] finalValues = new String[3];
        for (i = 0; i < 3; ++i) {
            String newValue = TestingUtil.v(method, (i + 1) * 2);
            if (testConfig.isRemove() && i > 0) {
                this.cache(this.siteName(i), 0).put((Object)key, (Object)newValue);
                finalValues[i] = newValue;
                continue;
            }
            finalValues[i] = testConfig.execute(this.cache(this.siteName(i), 0), key, initialValue, newValue);
        }
        for (i = 0; i < 3; ++i) {
            String fValue = finalValues[i];
            this.assertInSite(this.siteName(i), cache -> AssertJUnit.assertEquals((Object)fValue, (Object)cache.get((Object)key)));
        }
        this.iracManagerList.forEach(manualIracManager -> manualIracManager.disable(ManualIracManager.DisableMode.SEND));
        String expectedFinalValue = testConfig.getValueFromArray(finalValues);
        this.eventuallyAssertInAllSitesAndCaches(cache -> Objects.equals(expectedFinalValue, cache.get((Object)key)));
        this.assertNoDataLeak(null);
    }

    private static enum ConfigMode {
        NON_TX,
        PESSIMISTIC_TX,
        OPTIMISTIC_TX_RC,
        OPTIMISTIC_TX_RR;

    }

    static class TestOperationInterop
    implements IracTestOperation {
        private final TestOperation testOperation;

        TestOperationInterop(TestOperation testOperation) {
            this.testOperation = testOperation;
        }

        @Override
        public <K, V> V execute(Cache<K, V> cache, K key, V prevValue, V newValue) {
            return this.testOperation.execute(cache, key, prevValue, newValue);
        }

        @Override
        public boolean isRemove() {
            return TestOperation.REMOVE == this.testOperation || TestOperation.REMOVE_CONDITIONAL == this.testOperation;
        }

        @Override
        public <K, V> V insertValueAndReturnIfRequired(Cache<K, V> cache, K key, V value) {
            if (this.testOperation.requiresPreviousValue()) {
                cache.put(key, value);
                return value;
            }
            return null;
        }
    }

    static interface IracTestOperation {
        public <K, V> V execute(Cache<K, V> var1, K var2, V var3, V var4);

        public boolean isRemove();

        public <K, V> V insertValueAndReturnIfRequired(Cache<K, V> var1, K var2, V var3);

        default public <V> V getValueFromArray(V[] array) {
            return array[0];
        }
    }

    static class RemoveExpiredOperation
    implements IracTestOperation {
        private final ControlledTimeService timeService;

        RemoveExpiredOperation(ControlledTimeService timeService) {
            this.timeService = timeService;
        }

        @Override
        public <K, V> V execute(Cache<K, V> cache, K key, V prevValue, V newValue) {
            this.timeService.advance(TimeUnit.SECONDS.toMillis(10L));
            CompletionStages.join((CompletionStage)cache.getAdvancedCache().removeMaxIdleExpired(key, prevValue));
            return null;
        }

        @Override
        public boolean isRemove() {
            return true;
        }

        @Override
        public <K, V> V insertValueAndReturnIfRequired(Cache<K, V> cache, K key, V value) {
            cache.put(key, value, -1L, TimeUnit.SECONDS, 5L, TimeUnit.SECONDS);
            return value;
        }

        @Override
        public <V> V getValueFromArray(V[] array) {
            return array[1];
        }
    }
}

