/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.SitesConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TransportFlags;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"xsite"}, testName="xsite.BackupForConfigTest")
public class BackupForConfigTest
extends SingleCacheManagerTest {
    ConfigurationBuilder nycBackup;

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfigurationBuilder lonGc = GlobalConfigurationBuilder.defaultClusteredBuilder();
        TestCacheManagerFactory.amendDefaultCache(lonGc);
        ConfigurationBuilder lon = BackupForConfigTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
        lon.sites().addBackup().site("NYC").strategy(BackupConfiguration.BackupStrategy.SYNC);
        this.nycBackup = BackupForConfigTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
        this.nycBackup.sites().backupFor().remoteSite("NYC").remoteCache((String)lonGc.defaultCacheName().get());
        return TestCacheManagerFactory.createClusteredCacheManager(lonGc, lon, TransportFlags.minimalXsiteFlags());
    }

    public void testBackupForIsCorrect() {
        this.cacheManager.getCache();
        this.cacheManager.defineConfiguration("nycBackup", this.nycBackup.build());
        this.cacheManager.getCache("nycBackup");
        SitesConfiguration sitesConfig = this.cache("nycBackup").getCacheConfiguration().sites();
        AssertJUnit.assertEquals((String)this.getDefaultCacheName(), (String)sitesConfig.backupFor().remoteCache());
        AssertJUnit.assertEquals((String)"NYC", (String)sitesConfig.backupFor().remoteSite());
        sitesConfig.backupFor().isBackupFor("NYC", this.getDefaultCacheName());
    }
}

