/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.Arrays;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.jmx.TestMBeanServerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.manager.CacheContainer;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.InCacheMode;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.topology.ClusterTopologyManager;
import org.infinispan.topology.RebalancingStatus;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="statetransfer.RebalancePolicyJmxTest")
@CleanupAfterMethod
@InCacheMode(value={CacheMode.DIST_SYNC})
public class RebalancePolicyJmxTest
extends MultipleCacheManagersTest {
    private static final String REBALANCING_ENABLED = "rebalancingEnabled";
    private final MBeanServerLookup mBeanServerLookup = TestMBeanServerLookup.create();

    public void testJoinAndLeaveWithRebalanceSuspended() throws Exception {
        this.doTest(false);
    }

    public void testJoinAndLeaveWithRebalanceSuspendedAwaitingInitialTransfer() throws Exception {
        this.doTest(true);
    }

    @Override
    protected void createCacheManagers() throws Throwable {
    }

    private ConfigurationBuilder getConfigurationBuilder(boolean awaitInitialTransfer) {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.clustering().cacheMode(this.cacheMode).stateTransfer().awaitInitialTransfer(awaitInitialTransfer);
        return cb;
    }

    private GlobalConfigurationBuilder getGlobalConfigurationBuilder(String rackId) {
        int index = this.cacheManagers.size();
        GlobalConfigurationBuilder gcb = GlobalConfigurationBuilder.defaultClusteredBuilder();
        gcb.transport().rackId(rackId);
        TestCacheManagerFactory.configureJmx(gcb, this.getClass().getSimpleName() + index, this.mBeanServerLookup);
        return gcb;
    }

    private void doTest(boolean awaitInitialTransfer) throws Exception {
        this.addClusterEnabledCacheManager(this.getGlobalConfigurationBuilder("r1"), this.getConfigurationBuilder(awaitInitialTransfer));
        this.addClusterEnabledCacheManager(this.getGlobalConfigurationBuilder("r1"), this.getConfigurationBuilder(awaitInitialTransfer));
        this.waitForClusterToForm();
        MBeanServer mBeanServer = this.mBeanServerLookup.getMBeanServer();
        String domain0 = this.manager(1).getCacheManagerConfiguration().jmx().domain();
        ObjectName ltmName0 = TestingUtil.getCacheManagerObjectName(domain0, "DefaultCacheManager", "LocalTopologyManager");
        String domain1 = this.manager(1).getCacheManagerConfiguration().jmx().domain();
        ObjectName ltmName1 = TestingUtil.getCacheManagerObjectName(domain1, "DefaultCacheManager", "LocalTopologyManager");
        DistributionManager dm0 = this.advancedCache(0).getDistributionManager();
        AssertJUnit.assertEquals(Arrays.asList(this.address(0), this.address(1)), (Object)dm0.getCacheTopology().getCurrentCH().getMembers());
        AssertJUnit.assertNull((Object)dm0.getCacheTopology().getPendingCH());
        AssertJUnit.assertTrue((boolean)mBeanServer.isRegistered(ltmName0));
        AssertJUnit.assertTrue((boolean)((Boolean)mBeanServer.getAttribute(ltmName0, REBALANCING_ENABLED)));
        mBeanServer.setAttribute(ltmName0, new Attribute(REBALANCING_ENABLED, false));
        AssertJUnit.assertFalse((boolean)((Boolean)mBeanServer.getAttribute(ltmName0, REBALANCING_ENABLED)));
        log.debugf("Starting 2 new nodes", new Object[0]);
        this.addClusterEnabledCacheManager(this.getGlobalConfigurationBuilder("r2"), this.getConfigurationBuilder(awaitInitialTransfer));
        this.addClusterEnabledCacheManager(this.getGlobalConfigurationBuilder("r2"), this.getConfigurationBuilder(awaitInitialTransfer));
        this.cache(2);
        this.cache(3);
        ClusterTopologyManager ctm2 = TestingUtil.extractGlobalComponent((CacheContainer)this.manager(2), ClusterTopologyManager.class);
        AssertJUnit.assertFalse((boolean)ctm2.isRebalancingEnabled());
        ClusterTopologyManager ctm3 = TestingUtil.extractGlobalComponent((CacheContainer)this.manager(3), ClusterTopologyManager.class);
        AssertJUnit.assertFalse((boolean)ctm3.isRebalancingEnabled());
        StateTransferManager stm0 = TestingUtil.extractComponent(this.cache(0), StateTransferManager.class);
        AssertJUnit.assertEquals((String)RebalancingStatus.SUSPENDED.toString(), (String)stm0.getRebalancingStatus());
        Thread.sleep(1000L);
        AssertJUnit.assertFalse((boolean)((Boolean)mBeanServer.getAttribute(ltmName1, REBALANCING_ENABLED)));
        AssertJUnit.assertNull((Object)dm0.getCacheTopology().getPendingCH());
        AssertJUnit.assertEquals(Arrays.asList(this.address(0), this.address(1)), (Object)dm0.getCacheTopology().getCurrentCH().getMembers());
        log.debugf("Rebalancing with nodes %s %s %s %s", new Object[]{this.address(0), this.address(1), this.address(2), this.address(3)});
        mBeanServer.setAttribute(ltmName0, new Attribute(REBALANCING_ENABLED, true));
        AssertJUnit.assertTrue((boolean)((Boolean)mBeanServer.getAttribute(ltmName0, REBALANCING_ENABLED)));
        mBeanServer.setAttribute(ltmName0, new Attribute(REBALANCING_ENABLED, true));
        TestingUtil.waitForNoRebalance(this.cache(0), this.cache(1), this.cache(2), this.cache(3));
        AssertJUnit.assertNull((Object)dm0.getCacheTopology().getPendingCH());
        AssertJUnit.assertEquals((String)RebalancingStatus.COMPLETE.toString(), (String)stm0.getRebalancingStatus());
        ConsistentHash ch = dm0.getCacheTopology().getCurrentCH();
        AssertJUnit.assertEquals(Arrays.asList(this.address(0), this.address(1), this.address(2), this.address(3)), (Object)ch.getMembers());
        int numOwners = Math.min(this.cache(0).getCacheConfiguration().clustering().hash().numOwners(), ch.getMembers().size());
        for (int i = 0; i < ch.getNumSegments(); ++i) {
            AssertJUnit.assertEquals((int)numOwners, (int)ch.locateOwnersForSegment(i).size());
        }
        mBeanServer.setAttribute(ltmName1, new Attribute(REBALANCING_ENABLED, false));
        AssertJUnit.assertFalse((boolean)((Boolean)mBeanServer.getAttribute(ltmName0, REBALANCING_ENABLED)));
        AssertJUnit.assertFalse((boolean)((Boolean)mBeanServer.getAttribute(ltmName1, REBALANCING_ENABLED)));
        mBeanServer.setAttribute(ltmName1, new Attribute(REBALANCING_ENABLED, false));
        log.debugf("Stopping nodes %s %s", (Object)this.address(0), (Object)this.address(1));
        TestingUtil.killCacheManagers(this.manager(0), this.manager(1));
        Thread.sleep(1000L);
        DistributionManager dm2 = this.advancedCache(2).getDistributionManager();
        AssertJUnit.assertNull((Object)dm2.getCacheTopology().getPendingCH());
        ch = dm2.getCacheTopology().getCurrentCH();
        AssertJUnit.assertEquals(Arrays.asList(this.address(2), this.address(3)), (Object)ch.getMembers());
        if (this.cacheMode.isDistributed()) {
            for (int i = 0; i < ch.getNumSegments(); ++i) {
                AssertJUnit.assertEquals((int)1, (int)ch.locateOwnersForSegment(i).size());
            }
        }
        StateTransferManager stm2 = TestingUtil.extractComponent(this.cache(2), StateTransferManager.class);
        AssertJUnit.assertEquals((String)RebalancingStatus.SUSPENDED.toString(), (String)stm2.getRebalancingStatus());
        log.debugf("Rebalancing with nodes %s %s", (Object)this.address(2), (Object)this.address(3));
        String domain2 = this.manager(2).getCacheManagerConfiguration().jmx().domain();
        ObjectName ltmName2 = TestingUtil.getCacheManagerObjectName(domain2, "DefaultCacheManager", "LocalTopologyManager");
        String domain3 = this.manager(2).getCacheManagerConfiguration().jmx().domain();
        ObjectName ltmName3 = TestingUtil.getCacheManagerObjectName(domain3, "DefaultCacheManager", "LocalTopologyManager");
        mBeanServer.setAttribute(ltmName2, new Attribute(REBALANCING_ENABLED, true));
        AssertJUnit.assertTrue((boolean)((Boolean)mBeanServer.getAttribute(ltmName2, REBALANCING_ENABLED)));
        AssertJUnit.assertTrue((boolean)((Boolean)mBeanServer.getAttribute(ltmName3, REBALANCING_ENABLED)));
        TestingUtil.waitForNoRebalance(this.cache(2), this.cache(3));
        AssertJUnit.assertEquals((String)RebalancingStatus.COMPLETE.toString(), (String)stm2.getRebalancingStatus());
        AssertJUnit.assertNull((Object)dm2.getCacheTopology().getPendingCH());
        ch = dm2.getCacheTopology().getCurrentCH();
        AssertJUnit.assertEquals(Arrays.asList(this.address(2), this.address(3)), (Object)ch.getMembers());
        for (int i = 0; i < ch.getNumSegments(); ++i) {
            AssertJUnit.assertEquals((int)numOwners, (int)ch.locateOwnersForSegment(i).size());
        }
    }
}

