/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs;

import io.reactivex.rxjava3.internal.subscriptions.AsyncSubscription;
import io.reactivex.rxjava3.subscribers.TestSubscriber;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.Cache;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.sifs.Compactor;
import org.infinispan.persistence.sifs.EntryPosition;
import org.infinispan.persistence.sifs.EntryRecord;
import org.infinispan.persistence.sifs.SoftIndexFileStoreTestUtils;
import org.infinispan.persistence.sifs.configuration.SoftIndexFileStoreConfigurationBuilder;
import org.infinispan.persistence.support.WaitDelegatingNonBlockingStore;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestBlocking;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.reactivestreams.Subscription;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"stress"}, testName="persistence.sifs.SoftIndexFileStoreStressTest")
public class SoftIndexFileStoreStressTest
extends SingleCacheManagerTest {
    private static final String CACHE_NAME = "stress-test-cache";
    protected String tmpDirectory;

    @BeforeClass(alwaysRun=true)
    protected void setUpTempDir() {
        this.tmpDirectory = CommonsTestingUtil.tmpDirectory(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass(alwaysRun=true, dependsOnMethods={"destroyAfterClass"})
    protected void clearTempDir() throws IOException {
        try {
            SoftIndexFileStoreTestUtils.StatsValue statsValue = SoftIndexFileStoreTestUtils.readStatsFile(this.tmpDirectory, CACHE_NAME, log);
            long dataDirectorySize = SoftIndexFileStoreTestUtils.dataDirectorySize(this.tmpDirectory, CACHE_NAME);
            AssertJUnit.assertEquals((long)dataDirectorySize, (long)statsValue.getStatsSize());
        }
        finally {
            Util.recursiveFileRemove((String)this.tmpDirectory);
        }
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder();
        global.globalState().persistentLocation(CommonsTestingUtil.tmpDirectory(this.getClass()));
        global.cacheContainer().security().authorization().enable();
        return TestCacheManagerFactory.newDefaultCacheManager(false, global, new ConfigurationBuilder());
    }

    protected PersistenceConfigurationBuilder createCacheStoreConfig(PersistenceConfigurationBuilder persistence, String cacheName, boolean preload) {
        ((SoftIndexFileStoreConfigurationBuilder)((SoftIndexFileStoreConfigurationBuilder)persistence.addSoftIndexFileStore().dataLocation(Paths.get(this.tmpDirectory, "data").toString()).indexLocation(Paths.get(this.tmpDirectory, "index").toString()).maxFileSize(1000).async().enabled(true).purgeOnStartup(false)).preload(preload)).expiration().wakeUpInterval(Long.MAX_VALUE);
        return persistence;
    }

    public void testConstantReadsWithCompaction() throws Throwable {
        ConfigurationBuilder cb = TestCacheManagerFactory.getDefaultCacheConfiguration(false);
        this.createCacheStoreConfig(cb.persistence(), CACHE_NAME, false);
        TestingUtil.defineConfiguration(this.cacheManager, CACHE_NAME, cb.build());
        Cache cache = this.cacheManager.getCache(CACHE_NAME);
        cache.start();
        AtomicBoolean continueRunning = new AtomicBoolean(true);
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        for (Operation operation : Operation.values()) {
            futures.add(this.fork(() -> this.runOperationOnCache((Cache<String, Object>)cache, continueRunning, operation)));
        }
        long startTime = System.nanoTime();
        long secondsToRun = TimeUnit.MINUTES.toSeconds(10L);
        while (TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - startTime) < secondsToRun) {
            if (futures.stream().anyMatch(Future::isDone)) {
                continueRunning.set(false);
                break;
            }
            TestingUtil.sleepThread(200L);
        }
        continueRunning.set(false);
        try {
            this.get(10L, TimeUnit.SECONDS, (Future[])futures.toArray(Future[]::new));
        }
        catch (Throwable t) {
            log.tracef(Util.threadDump(), new Object[0]);
            throw t;
        }
        TestingUtil.killCacheManagers(this.cacheManager);
        this.cacheManager = this.createCacheManager();
        TestingUtil.defineConfiguration(this.cacheManager, CACHE_NAME, cb.build());
        Cache newCache = this.cacheManager.getCache(CACHE_NAME);
        newCache.start();
        ArrayList entries = new ArrayList(newCache.entrySet());
        log.info((Object)("Size of entries after restart was: " + entries.size()));
    }

    private void runOperationOnCache(Cache<String, Object> cache, AtomicBoolean continueRunning, Operation operation) {
        int numKeys = 22;
        for (int i = 0; i < numKeys; ++i) {
            cache.put((Object)("key-" + i), (Object)("value-" + i));
        }
        while (continueRunning.get()) {
            operation.execute(cache, numKeys);
        }
        cache.clear();
    }

    private void get(long time, TimeUnit unit, Future<?> ... futures) throws Throwable {
        for (Future<?> future : futures) {
            TestBlocking.get(future, time, unit);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum Operation {
        READ{

            @Override
            public void execute(Cache<String, Object> cache, int keySpace) {
                int i = ThreadLocalRandom.current().nextInt(keySpace);
                Object value = cache.get((Object)("key-" + i));
                if (value != null) {
                    AssertJUnit.assertEquals((Object)("value-" + i), (Object)value);
                }
            }
        }
        ,
        WRITE{

            @Override
            public void execute(Cache<String, Object> cache, int keySpace) {
                int i = ThreadLocalRandom.current().nextInt(keySpace);
                String sb = i + "vjaofijeawofiejafioeh23uh123eu213heu1he u1ni 1uh13iueh 1iuehn12ujhen12ujhn2112w!@KEO@J!E I!@JEIO! J@@@E1j ie1jvjaofijeawofiejafioeha".repeat(i);
                cache.put((Object)("k" + i), (Object)sb);
            }
        }
        ,
        REMOVE{

            @Override
            public void execute(Cache<String, Object> cache, int keySpace) {
                int i = ThreadLocalRandom.current().nextInt(keySpace);
                cache.remove((Object)("k" + i));
            }
        }
        ,
        CLEAR{

            @Override
            public void execute(Cache<String, Object> cache, int keySpace) {
                cache.clear();
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        ,
        ITERATE{

            @Override
            public void execute(Cache<String, Object> cache, int keySpace) {
                ArrayList list = new ArrayList(cache.entrySet());
                if (list.size() == 1000) {
                    log.tracef("List size was: " + list.size(), new Object[0]);
                }
            }
        }
        ,
        COMPACTION{

            @Override
            public void execute(Cache<String, Object> cache, int keySpace) {
                WaitDelegatingNonBlockingStore<String, Object> store = TestingUtil.getFirstStoreWait(cache);
                Compactor compactor = (Compactor)TestingUtil.extractField(store.delegate(), "compactor");
                final TestSubscriber testSubscriber = TestSubscriber.create();
                testSubscriber.onSubscribe((Subscription)new AsyncSubscription());
                Compactor.CompactionExpirationSubscriber expSub = new Compactor.CompactionExpirationSubscriber(){

                    public void onEntryPosition(EntryPosition entryPosition) {
                    }

                    public void onEntryEntryRecord(EntryRecord entryRecord) {
                    }

                    public void onComplete() {
                        testSubscriber.onComplete();
                    }

                    public void onError(Throwable t) {
                        testSubscriber.onError(t);
                    }
                };
                compactor.performExpirationCompaction(expSub);
                ((TestSubscriber)((TestSubscriber)testSubscriber.awaitDone(5L, TimeUnit.SECONDS)).assertComplete()).assertNoErrors();
            }
        };


        public abstract void execute(Cache<String, Object> var1, int var2);
    }
}

