/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence;

import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.impl.CacheLoaderInterceptor;
import org.infinispan.interceptors.impl.CacheWriterInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.UnnecessaryLoadingTest;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.ClassLoaderManagerDisablingTest")
public class ClassLoaderManagerDisablingTest
extends AbstractInfinispanTest {
    public void testStoreDisabling() {
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration(false);
        builder.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class);
        this.disableWithConfiguration(builder);
    }

    public void testAsyncStoreDisabling() {
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration(false);
        ((DummyInMemoryStoreConfigurationBuilder)builder.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).async().enable();
        this.disableWithConfiguration(builder);
    }

    public void testChainingStoreDisabling() {
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration(false);
        ((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)builder.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).async().enable();
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(builder);
        try {
            this.checkAndDisableStore(cm, 2);
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cm);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cm);
    }

    public void testDisablingWithPassivation() {
        ConfigurationBuilder builder = this.createPersistenceConfiguration();
        this.enablePassivation(builder);
        this.disableWithConfiguration(builder);
    }

    public void testDisablingWithClusteredPassivation() {
        ConfigurationBuilder builder = this.createClusterConfiguration(CacheMode.DIST_SYNC);
        this.enablePassivation(builder);
        this.disableWithClusteredConfiguration(builder);
    }

    public void testClusteredDisabling() {
        ConfigurationBuilder builder = this.createClusterConfiguration(CacheMode.DIST_SYNC);
        this.disableWithClusteredConfiguration(builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDisableWithMultipleStores() {
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration(false);
        PersistenceConfigurationBuilder p = builder.persistence();
        ((DummyInMemoryStoreConfigurationBuilder)p.addStore(DummyInMemoryStoreConfigurationBuilder.class)).fetchPersistentState(true);
        p.addStore(UnnecessaryLoadingTest.CountingStoreConfigurationBuilder.class);
        EmbeddedCacheManager cacheManager = null;
        try {
            cacheManager = TestCacheManagerFactory.createCacheManager(builder);
            Cache cache = cacheManager.getCache();
            PersistenceManager pm = TestingUtil.extractComponent(cache, PersistenceManager.class);
            Set stores = pm.getStores(Object.class);
            AssertJUnit.assertEquals((int)2, (int)stores.size());
            pm.disableStore(UnnecessaryLoadingTest.CountingStore.class.getName());
            stores = pm.getStores(Object.class);
            AssertJUnit.assertEquals((int)1, (int)stores.size());
            DummyInMemoryStore dummyInMemoryStore = (DummyInMemoryStore)stores.iterator().next();
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cacheManager);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cacheManager);
    }

    private void checkAndDisableStore(EmbeddedCacheManager cm) {
        this.checkAndDisableStore(cm, 1);
    }

    private void checkAndDisableStore(EmbeddedCacheManager cm, int count) {
        Cache cache = cm.getCache();
        PersistenceManager clm = TestingUtil.extractComponent(cache, PersistenceManager.class);
        Set stores = clm.getStores(DummyInMemoryStore.class);
        AssertJUnit.assertEquals((int)count, (int)stores.size());
        stores.forEach(store -> AssertJUnit.assertTrue((boolean)store.isRunning()));
        clm.disableStore(DummyInMemoryStore.class.getName());
        stores.forEach(store -> AssertJUnit.assertFalse((boolean)store.isRunning()));
        AsyncInterceptor interceptor = TestingUtil.extractInterceptorChain(cache).findInterceptorExtending(CacheLoaderInterceptor.class);
        AssertJUnit.assertNull((Object)interceptor);
        interceptor = TestingUtil.extractInterceptorChain(cache).findInterceptorExtending(CacheWriterInterceptor.class);
        AssertJUnit.assertNull((Object)interceptor);
    }

    private ConfigurationBuilder createClusterConfiguration(CacheMode cacheMode) {
        ConfigurationBuilder builder = this.createPersistenceConfiguration();
        builder.clustering().cacheMode(cacheMode);
        return builder;
    }

    private ConfigurationBuilder createPersistenceConfiguration() {
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration(false);
        builder.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class);
        return builder;
    }

    private void enablePassivation(ConfigurationBuilder builder) {
        builder.persistence().passivation(true);
        builder.memory().size(1L);
    }

    private void disableWithConfiguration(ConfigurationBuilder builder) {
        EmbeddedCacheManager cacheManager = null;
        try {
            cacheManager = TestCacheManagerFactory.createCacheManager(builder);
            this.checkAndDisableStore(cacheManager);
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cacheManager);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cacheManager);
    }

    private void disableWithClusteredConfiguration(ConfigurationBuilder builder) {
        EmbeddedCacheManager cacheManager = null;
        try {
            cacheManager = TestCacheManagerFactory.createClusteredCacheManager(builder);
            this.checkAndDisableStore(cacheManager);
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cacheManager);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cacheManager);
    }
}

