/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.context;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.IntStream;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.context.Flag;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="context.FlagBitsetTest")
public class FlagBitsetTest
extends AbstractInfinispanTest {
    private static final Flag[] FLAGS_CACHED = Flag.values();

    public void testUniqueness() {
        HashMap<Long, Flag> bits = new HashMap<Long, Flag>(FLAGS_CACHED.length);
        for (Flag flag : FLAGS_CACHED) {
            Flag existing = bits.putIfAbsent(EnumUtil.bitSetOf((Enum)flag), flag);
            AssertJUnit.assertNull((String)("Conflict flags: " + String.valueOf(existing) + " and " + String.valueOf(flag)), (Object)existing);
        }
    }

    public void testBitSetOf() {
        int startIdx = ThreadLocalRandom.current().nextInt(FLAGS_CACHED.length - 4);
        Flag f1 = FLAGS_CACHED[startIdx];
        Flag f2 = FLAGS_CACHED[startIdx + 1];
        Flag f3 = FLAGS_CACHED[startIdx + 2];
        Flag f4 = FLAGS_CACHED[startIdx + 3];
        log.debugf("Flags: %s, %s, %s, %s", new Object[]{f1, f2, f3, f4});
        FlagBitsetTest.assertBitSet(EnumUtil.bitSetOf((Enum)f1), startIdx, 1);
        FlagBitsetTest.assertBitSet(EnumUtil.bitSetOf((Enum)f1, (Enum)f2), startIdx, 2);
        FlagBitsetTest.assertBitSet(EnumUtil.bitSetOf((Enum)f1, (Enum)f2, (Enum[])new Enum[]{f3}), startIdx, 3);
        FlagBitsetTest.assertBitSet(EnumUtil.bitSetOf((Enum)f1, (Enum)f2, (Enum[])new Enum[]{f3, f4}), startIdx, 4);
    }

    public void testEnumFromBitSet() {
        int startIdx = ThreadLocalRandom.current().nextInt(FLAGS_CACHED.length - 4);
        Flag f1 = FLAGS_CACHED[startIdx];
        Flag f2 = FLAGS_CACHED[startIdx + 1];
        Flag f3 = FLAGS_CACHED[startIdx + 2];
        Flag f4 = FLAGS_CACHED[startIdx + 3];
        log.debugf("Flags: %s, %s, %s, %s", new Object[]{f1, f2, f3, f4});
        AssertJUnit.assertEquals(EnumSet.of(f1), (Object)EnumUtil.enumSetOf((long)EnumUtil.bitSetOf((Enum)f1), Flag.class));
        AssertJUnit.assertEquals(EnumSet.of(f1, f2), (Object)EnumUtil.enumSetOf((long)EnumUtil.bitSetOf((Enum)f1, (Enum)f2), Flag.class));
        AssertJUnit.assertEquals(EnumSet.of(f1, f2, f3), (Object)EnumUtil.enumSetOf((long)EnumUtil.bitSetOf((Enum)f1, (Enum)f2, (Enum[])new Enum[]{f3}), Flag.class));
        AssertJUnit.assertEquals(EnumSet.of(f1, f2, f3, f4), (Object)EnumUtil.enumSetOf((long)EnumUtil.bitSetOf((Enum)f1, (Enum)f2, (Enum[])new Enum[]{f3, f4}), Flag.class));
    }

    public void testEnumSet() {
        int startIdx = ThreadLocalRandom.current().nextInt(FLAGS_CACHED.length - 4);
        Flag f1 = FLAGS_CACHED[startIdx];
        Flag f2 = FLAGS_CACHED[startIdx + 1];
        Flag f3 = FLAGS_CACHED[startIdx + 2];
        Flag f4 = FLAGS_CACHED[startIdx + 3];
        log.debugf("Flags: %s, %s, %s, %s", new Object[]{f1, f2, f3, f4});
        FlagBitsetTest.assertBitSet(EnumUtil.setEnum((long)EnumUtil.bitSetOf((Enum)f1), (Enum)f2), startIdx, 2);
        FlagBitsetTest.assertBitSet(EnumUtil.setEnums((long)EnumUtil.bitSetOf((Enum)f1), Arrays.asList(f2, f3, f4)), startIdx, 4);
    }

    public void testEnumUnset() {
        int startIdx = ThreadLocalRandom.current().nextInt(FLAGS_CACHED.length - 4);
        Flag f1 = FLAGS_CACHED[startIdx];
        Flag f2 = FLAGS_CACHED[startIdx + 1];
        Flag f3 = FLAGS_CACHED[startIdx + 2];
        log.debugf("Flags: %s, %s, %s", (Object)f1, (Object)f2, (Object)f3);
        FlagBitsetTest.assertBitSet(EnumUtil.unsetEnum((long)EnumUtil.bitSetOf((Enum)f1, (Enum)f2, (Enum[])new Enum[]{f3}), (Enum)f3), startIdx, 2);
    }

    public void testBitSetOperations() {
        int startIdx = ThreadLocalRandom.current().nextInt(FLAGS_CACHED.length - 4);
        Flag f1 = FLAGS_CACHED[startIdx];
        Flag f2 = FLAGS_CACHED[startIdx + 1];
        Flag f3 = FLAGS_CACHED[startIdx + 2];
        Flag f4 = FLAGS_CACHED[startIdx + 3];
        log.debugf("Flags: %s, %s, %s, %s", new Object[]{f1, f2, f3, f4});
        FlagBitsetTest.assertBitSet(EnumUtil.mergeBitSets((long)EnumUtil.bitSetOf((Enum)f1), (long)EnumUtil.bitSetOf((Enum)f2, (Enum)f3)), startIdx, 3);
        FlagBitsetTest.assertBitSet(EnumUtil.diffBitSets((long)EnumUtil.bitSetOf((Enum)f1, (Enum)f2, (Enum[])new Enum[]{f3, f4}), (long)EnumUtil.bitSetOf((Enum)f4)), startIdx, 3);
        AssertJUnit.assertTrue((boolean)EnumUtil.containsAll((long)EnumUtil.bitSetOf((Enum)f1, (Enum)f2), (long)EnumUtil.bitSetOf((Enum)f1, (Enum)f2)));
        AssertJUnit.assertTrue((boolean)EnumUtil.containsAll((long)EnumUtil.bitSetOf((Enum)f1, (Enum)f2), (long)EnumUtil.bitSetOf((Enum)f1)));
        AssertJUnit.assertFalse((boolean)EnumUtil.containsAll((long)EnumUtil.bitSetOf((Enum)f1, (Enum)f2), (long)EnumUtil.bitSetOf((Enum)f1, (Enum)f3)));
        AssertJUnit.assertFalse((boolean)EnumUtil.containsAll((long)EnumUtil.bitSetOf((Enum)f1, (Enum)f2), (long)EnumUtil.bitSetOf((Enum)f4)));
        AssertJUnit.assertTrue((boolean)EnumUtil.containsAny((long)EnumUtil.bitSetOf((Enum)f1, (Enum)f2), (long)EnumUtil.bitSetOf((Enum)f1, (Enum)f2)));
        AssertJUnit.assertTrue((boolean)EnumUtil.containsAny((long)EnumUtil.bitSetOf((Enum)f1, (Enum)f2), (long)EnumUtil.bitSetOf((Enum)f1)));
        AssertJUnit.assertTrue((boolean)EnumUtil.containsAny((long)EnumUtil.bitSetOf((Enum)f1, (Enum)f2), (long)EnumUtil.bitSetOf((Enum)f1, (Enum)f3)));
        AssertJUnit.assertFalse((boolean)EnumUtil.containsAny((long)EnumUtil.bitSetOf((Enum)f1, (Enum)f2), (long)EnumUtil.bitSetOf((Enum)f3, (Enum)f4)));
        AssertJUnit.assertFalse((boolean)EnumUtil.containsAny((long)EnumUtil.bitSetOf((Enum)f1, (Enum)f2), (long)EnumUtil.bitSetOf((Enum)f3)));
    }

    private static void assertBitSet(long bitSet, int startIdx, int range) {
        IntStream.range(0, startIdx).forEach(idx -> FlagBitsetTest.assertNotFlag(bitSet, FLAGS_CACHED[idx]));
        IntStream.range(startIdx, startIdx + range).forEach(idx -> FlagBitsetTest.assertFlag(bitSet, FLAGS_CACHED[idx]));
        IntStream.range(startIdx + range, FLAGS_CACHED.length).forEach(idx -> FlagBitsetTest.assertNotFlag(bitSet, FLAGS_CACHED[idx]));
    }

    private static void assertFlag(long bitset, Flag flag) {
        AssertJUnit.assertTrue((String)("Flag " + String.valueOf(flag) + " should be in bitset!"), (boolean)EnumUtil.hasEnum((long)bitset, (Enum)flag));
    }

    private static void assertNotFlag(long bitset, Flag flag) {
        AssertJUnit.assertFalse((String)("Flag " + String.valueOf(flag) + " should not be in bitset!"), (boolean)EnumUtil.hasEnum((long)bitset, (Enum)flag));
    }
}

