/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.constraintvalidators.hv;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import org.hibernate.validator.constraints.IpAddress;
import org.hibernate.validator.internal.util.Contracts;

public class IpAddressValidator
implements ConstraintValidator<IpAddress, CharSequence> {
    private IpAddressValidationAlgorithm ipAddressValidationAlgorithm;

    public void initialize(IpAddress constraintAnnotation) {
        this.ipAddressValidationAlgorithm = IpAddressValidationAlgorithm.from(constraintAnnotation.type());
    }

    public boolean isValid(CharSequence charSequence, ConstraintValidatorContext constraintValidatorContext) {
        if (charSequence == null) {
            return true;
        }
        return this.ipAddressValidationAlgorithm.isValid(charSequence);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum IpAddressValidationAlgorithm {
        IPv4{

            @Override
            public boolean isValid(CharSequence ipAddress) {
                return 1.isValidIpV4(ipAddress, 0, ipAddress.length());
            }
        }
        ,
        IPv6{
            private static final int IPv4_SEGMENTS = 2;
            private static final int IPv6_SEGMENTS_MAX_TOTAL = 8;

            @Override
            public boolean isValid(CharSequence charSequence) {
                if (charSequence.length() < 2) {
                    return false;
                }
                String ipAddress = charSequence.toString();
                int length = ipAddress.indexOf(37);
                if (length < 0) {
                    length = ipAddress.length();
                }
                int i = 0;
                int numberOfConsumedSegments = 0;
                if (ipAddress.charAt(i) == ':' && ipAddress.charAt(++i) != ':') {
                    return false;
                }
                boolean hasSuppression = false;
                boolean previousConsumedTokenIsDigit = false;
                int segmentLength = 0;
                int val = 0;
                int curtok = i;
                while (i < length) {
                    char currentCharacter;
                    if ((currentCharacter = ipAddress.charAt(i++)) == ':') {
                        curtok = i;
                        if (!previousConsumedTokenIsDigit) {
                            if (hasSuppression) {
                                return false;
                            }
                            hasSuppression = true;
                            continue;
                        }
                        if (i == length) {
                            return false;
                        }
                        if (++numberOfConsumedSegments > 8) {
                            return false;
                        }
                        previousConsumedTokenIsDigit = false;
                        val = 0;
                        segmentLength = 0;
                        continue;
                    }
                    if (currentCharacter == '.') {
                        if (numberOfConsumedSegments + 2 <= 8) {
                            if (!2.isValidIpV4(ipAddress, curtok, length)) {
                                return false;
                            }
                        } else {
                            return false;
                        }
                        previousConsumedTokenIsDigit = false;
                        break;
                    }
                    char lowerCh = Character.toLowerCase(currentCharacter);
                    int chval = lowerCh >= 'a' && lowerCh <= 'f' ? lowerCh - 97 + 10 : currentCharacter - 48;
                    if (chval > -1 && chval < 17) {
                        val <<= 4;
                        if ((val |= chval) > 65535) {
                            return false;
                        }
                        previousConsumedTokenIsDigit = true;
                        if (++segmentLength != 5) continue;
                        return false;
                    }
                    return false;
                }
                if (previousConsumedTokenIsDigit) {
                    if (numberOfConsumedSegments + 1 > 8) {
                        return false;
                    }
                    ++numberOfConsumedSegments;
                }
                if (hasSuppression) {
                    return numberOfConsumedSegments < 8;
                }
                return numberOfConsumedSegments == 8;
            }
        }
        ,
        ANY{

            @Override
            public boolean isValid(CharSequence charSequence) {
                return IPv4.isValid(charSequence) || IPv6.isValid(charSequence);
            }
        };


        abstract boolean isValid(CharSequence var1);

        static IpAddressValidationAlgorithm from(IpAddress.Type type) {
            Contracts.assertNotNull((Object)type);
            return switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case IpAddress.Type.IPv4 -> IPv4;
                case IpAddress.Type.IPv6 -> IPv6;
                case IpAddress.Type.ANY -> ANY;
            };
        }

        static boolean isValidIpV4(CharSequence string, int start, int end) {
            int length = end - start;
            if (length < 7 || length > 15) {
                return false;
            }
            int segmentValue = 0;
            int segments = 1;
            boolean newSegment = true;
            for (int i = start; i < end; ++i) {
                char c = string.charAt(i);
                if (c == '.') {
                    if (newSegment || segmentValue < 0 || segmentValue > 255 || segments == 4) {
                        return false;
                    }
                    ++segments;
                    segmentValue = 0;
                    newSegment = true;
                    continue;
                }
                int digit = c - 48;
                if (digit < 0 || digit > 9) {
                    return false;
                }
                segmentValue *= 10;
                if (!newSegment && (segmentValue += digit) < 10) {
                    return false;
                }
                newSegment = false;
            }
            return !newSegment && segmentValue >= 0 && segmentValue <= 255 && segments == 4;
        }
    }
}

