/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.constraintvalidators.bv.time;

import java.lang.annotation.Annotation;
import java.time.Clock;
import javax.validation.ClockProvider;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public abstract class AbstractEpochBasedTimeValidator<C extends Annotation, T>
implements ConstraintValidator<C, T> {
    private static final Log LOG = LoggerFactory.make();

    public boolean isValid(T value, ConstraintValidatorContext context) {
        Clock reference;
        if (value == null) {
            return true;
        }
        try {
            ClockProvider clockProvider = context.getClockProvider();
            reference = clockProvider.getClock();
        }
        catch (Exception e) {
            throw LOG.getUnableToGetCurrentTimeFromClockProvider(e);
        }
        int result = Long.compare(this.getEpochMillis(value, reference), reference.millis());
        return this.isValid(result);
    }

    protected abstract long getEpochMillis(T var1, Clock var2);

    protected abstract boolean isValid(int var1);
}

