/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge;

import java.util.Objects;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeFromIndexedValueContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeToIndexedValueContext;
import org.hibernate.search.util.common.annotation.Incubating;

public interface ValueBridge<V, F>
extends AutoCloseable {
    public F toIndexedValue(V var1, ValueBridgeToIndexedValueContext var2);

    default public V fromIndexedValue(F value, ValueBridgeFromIndexedValueContext context) {
        throw new UnsupportedOperationException("Bridge " + String.valueOf(this) + " does not implement fromIndexedValue(...).");
    }

    default public F parse(String value) {
        throw new UnsupportedOperationException("Bridge " + this.toString() + " does not support parsing a value from a String. Trying to parse the value: " + value + ".");
    }

    @Incubating
    default public String format(F value) {
        return Objects.toString(value, null);
    }

    default public boolean isCompatibleWith(ValueBridge<?, ?> other) {
        return this.equals(other);
    }

    @Override
    default public void close() {
    }
}

