/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.search.definition.binding.builtin;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Optional;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.definition.ProjectionDefinitionContext;
import org.hibernate.search.engine.search.projection.definition.spi.AbstractProjectionDefinition;
import org.hibernate.search.engine.search.projection.dsl.SearchProjectionFactory;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.search.definition.binding.ProjectionBinder;
import org.hibernate.search.mapper.pojo.search.definition.binding.ProjectionBindingContext;
import org.hibernate.search.mapper.pojo.search.definition.binding.ProjectionBindingMultiContext;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.spi.ToStringTreeAppender;

public final class HighlightProjectionBinder
implements ProjectionBinder {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String fieldPathOrNull;
    private String highlighterName;

    public static HighlightProjectionBinder create() {
        return HighlightProjectionBinder.create(null);
    }

    public static HighlightProjectionBinder create(String fieldPath) {
        return new HighlightProjectionBinder(fieldPath);
    }

    private HighlightProjectionBinder(String fieldPathOrNull) {
        this.fieldPathOrNull = fieldPathOrNull;
    }

    public HighlightProjectionBinder highlighter(String highlighterName) {
        this.highlighterName = highlighterName;
        return this;
    }

    @Override
    public void bind(ProjectionBindingContext context) {
        String fieldPath = this.fieldPathOrFail(context);
        Class<List> rawType = context.constructorParameter().rawType();
        if (!rawType.isAssignableFrom(List.class)) {
            throw log.invalidParameterTypeForHighlightProjectionInProjectionConstructor(rawType);
        }
        Optional<? extends ProjectionBindingMultiContext> multiOptional = context.multi();
        if (!multiOptional.isPresent()) {
            throw log.invalidParameterTypeForHighlightProjectionInProjectionConstructor(rawType);
        }
        ProjectionBindingMultiContext multi = multiOptional.get();
        multi.definition(String.class, new Definition(fieldPath, this.highlighterName));
    }

    private String fieldPathOrFail(ProjectionBindingContext context) {
        if (this.fieldPathOrNull != null) {
            return this.fieldPathOrNull;
        }
        Optional<String> paramName = context.constructorParameter().name();
        if (!paramName.isPresent()) {
            throw log.missingParameterNameForHighlightProjectionInProjectionConstructor();
        }
        return paramName.get();
    }

    private static class Definition
    extends AbstractProjectionDefinition<List<String>> {
        private final String fieldPath;
        private final String highlighterName;

        private Definition(String fieldPath, String highlighterName) {
            this.fieldPath = fieldPath;
            this.highlighterName = highlighterName;
        }

        protected String type() {
            return "highlight";
        }

        public void appendTo(ToStringTreeAppender appender) {
            super.appendTo(appender);
            appender.attribute("fieldPath", (Object)this.fieldPath);
            appender.attribute("highlighter", (Object)this.highlighterName);
        }

        public SearchProjection<List<String>> create(SearchProjectionFactory<?, ?> factory, ProjectionDefinitionContext context) {
            return factory.highlight(this.fieldPath).highlighter(this.highlighterName).toProjection();
        }
    }
}

